/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CloudwatchAlarmActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that updates a CloudWatch alarm.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudwatchAlarmAction implements StructuredPojo,
        ToCopyableBuilder<CloudwatchAlarmAction.Builder, CloudwatchAlarmAction> {
    private final String roleArn;

    private final String alarmName;

    private final String stateReason;

    private final String stateValue;

    private CloudwatchAlarmAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.alarmName = builder.alarmName;
        this.stateReason = builder.stateReason;
        this.stateValue = builder.stateValue;
    }

    /**
     * <p>
     * The IAM role that allows access to the CloudWatch alarm.
     * </p>
     * 
     * @return The IAM role that allows access to the CloudWatch alarm.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The CloudWatch alarm name.
     * </p>
     * 
     * @return The CloudWatch alarm name.
     */
    public String alarmName() {
        return alarmName;
    }

    /**
     * <p>
     * The reason for the alarm change.
     * </p>
     * 
     * @return The reason for the alarm change.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     * </p>
     * 
     * @return The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
     */
    public String stateValue() {
        return stateValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(stateValue());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchAlarmAction)) {
            return false;
        }
        CloudwatchAlarmAction other = (CloudwatchAlarmAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(alarmName(), other.alarmName())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(stateValue(), other.stateValue());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (alarmName() != null) {
            sb.append("AlarmName: ").append(alarmName()).append(",");
        }
        if (stateReason() != null) {
            sb.append("StateReason: ").append(stateReason()).append(",");
        }
        if (stateValue() != null) {
            sb.append("StateValue: ").append(stateValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "alarmName":
            return Optional.of(clazz.cast(alarmName()));
        case "stateReason":
            return Optional.of(clazz.cast(stateReason()));
        case "stateValue":
            return Optional.of(clazz.cast(stateValue()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudwatchAlarmActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudwatchAlarmAction> {
        /**
         * <p>
         * The IAM role that allows access to the CloudWatch alarm.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that allows access to the CloudWatch alarm.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The CloudWatch alarm name.
         * </p>
         * 
         * @param alarmName
         *        The CloudWatch alarm name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarmName(String alarmName);

        /**
         * <p>
         * The reason for the alarm change.
         * </p>
         * 
         * @param stateReason
         *        The reason for the alarm change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         * </p>
         * 
         * @param stateValue
         *        The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateValue(String stateValue);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String alarmName;

        private String stateReason;

        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchAlarmAction model) {
            roleArn(model.roleArn);
            alarmName(model.alarmName);
            stateReason(model.stateReason);
            stateValue(model.stateValue);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAlarmName() {
            return alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateValue() {
            return stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        @Override
        public CloudwatchAlarmAction build() {
            return new CloudwatchAlarmAction(this);
        }
    }
}
