/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateKeysAndCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateKeysAndCertificateRequest extends IoTRequest implements
        ToCopyableBuilder<CreateKeysAndCertificateRequest.Builder, CreateKeysAndCertificateRequest> {
    private final Boolean setAsActive;

    private CreateKeysAndCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.setAsActive = builder.setAsActive;
    }

    /**
     * <p>
     * Specifies whether the certificate is active.
     * </p>
     * 
     * @return Specifies whether the certificate is active.
     */
    public Boolean setAsActive() {
        return setAsActive;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(setAsActive());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKeysAndCertificateRequest)) {
            return false;
        }
        CreateKeysAndCertificateRequest other = (CreateKeysAndCertificateRequest) obj;
        return Objects.equals(setAsActive(), other.setAsActive());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (setAsActive() != null) {
            sb.append("SetAsActive: ").append(setAsActive()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "setAsActive":
            return Optional.of(clazz.cast(setAsActive()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, CreateKeysAndCertificateRequest> {
        /**
         * <p>
         * Specifies whether the certificate is active.
         * </p>
         * 
         * @param setAsActive
         *        Specifies whether the certificate is active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setAsActive(Boolean setAsActive);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private Boolean setAsActive;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKeysAndCertificateRequest model) {
            setAsActive(model.setAsActive);
        }

        public final Boolean getSetAsActive() {
            return setAsActive;
        }

        @Override
        public final Builder setAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
            return this;
        }

        public final void setSetAsActive(Boolean setAsActive) {
            this.setAsActive = setAsActive;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateKeysAndCertificateRequest build() {
            return new CreateKeysAndCertificateRequest(this);
        }
    }
}
