/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the CreatePolicyVersion operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePolicyVersionResponse extends IoTResponse implements
        ToCopyableBuilder<CreatePolicyVersionResponse.Builder, CreatePolicyVersionResponse> {
    private final String policyArn;

    private final String policyDocument;

    private final String policyVersionId;

    private final Boolean isDefaultVersion;

    private CreatePolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.policyVersionId = builder.policyVersionId;
        this.isDefaultVersion = builder.isDefaultVersion;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The policy version ID.
     * </p>
     * 
     * @return The policy version ID.
     */
    public String policyVersionId() {
        return policyVersionId;
    }

    /**
     * <p>
     * Specifies whether the policy version is the default.
     * </p>
     * 
     * @return Specifies whether the policy version is the default.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyVersionResponse)) {
            return false;
        }
        CreatePolicyVersionResponse other = (CreatePolicyVersionResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(policyVersionId(), other.policyVersionId())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyArn() != null) {
            sb.append("PolicyArn: ").append(policyArn()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (policyVersionId() != null) {
            sb.append("PolicyVersionId: ").append(policyVersionId()).append(",");
        }
        if (isDefaultVersion() != null) {
            sb.append("IsDefaultVersion: ").append(isDefaultVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.of(clazz.cast(policyArn()));
        case "policyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "policyVersionId":
            return Optional.of(clazz.cast(policyVersionId()));
        case "isDefaultVersion":
            return Optional.of(clazz.cast(isDefaultVersion()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, CreatePolicyVersionResponse> {
        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The policy version ID.
         * </p>
         * 
         * @param policyVersionId
         *        The policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersionId(String policyVersionId);

        /**
         * <p>
         * Specifies whether the policy version is the default.
         * </p>
         * 
         * @param isDefaultVersion
         *        Specifies whether the policy version is the default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String policyArn;

        private String policyDocument;

        private String policyVersionId;

        private Boolean isDefaultVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyVersionResponse model) {
            policyArn(model.policyArn);
            policyDocument(model.policyDocument);
            policyVersionId(model.policyVersionId);
            isDefaultVersion(model.isDefaultVersion);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getPolicyVersionId() {
            return policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        @Override
        public CreatePolicyVersionResponse build() {
            return new CreatePolicyVersionResponse(this);
        }
    }
}
