/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output of the DescribeCertificate operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCertificateResponse extends IoTResponse implements
        ToCopyableBuilder<DescribeCertificateResponse.Builder, DescribeCertificateResponse> {
    private final CertificateDescription certificateDescription;

    private DescribeCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.certificateDescription = builder.certificateDescription;
    }

    /**
     * <p>
     * The description of the certificate.
     * </p>
     * 
     * @return The description of the certificate.
     */
    public CertificateDescription certificateDescription() {
        return certificateDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCertificateResponse)) {
            return false;
        }
        DescribeCertificateResponse other = (DescribeCertificateResponse) obj;
        return Objects.equals(certificateDescription(), other.certificateDescription());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (certificateDescription() != null) {
            sb.append("CertificateDescription: ").append(certificateDescription()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateDescription":
            return Optional.of(clazz.cast(certificateDescription()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, DescribeCertificateResponse> {
        /**
         * <p>
         * The description of the certificate.
         * </p>
         * 
         * @param certificateDescription
         *        The description of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateDescription(CertificateDescription certificateDescription);

        /**
         * <p>
         * The description of the certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link CertificateDescription.Builder} avoiding the
         * need to create one manually via {@link CertificateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link CertificateDescription.Builder#build()} is called immediately and
         * its result is passed to {@link #certificateDescription(CertificateDescription)}.
         * 
         * @param certificateDescription
         *        a consumer that will call methods on {@link CertificateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateDescription(CertificateDescription)
         */
        default Builder certificateDescription(Consumer<CertificateDescription.Builder> certificateDescription) {
            return certificateDescription(CertificateDescription.builder().apply(certificateDescription).build());
        }
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private CertificateDescription certificateDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCertificateResponse model) {
            certificateDescription(model.certificateDescription);
        }

        public final CertificateDescription.Builder getCertificateDescription() {
            return certificateDescription != null ? certificateDescription.toBuilder() : null;
        }

        @Override
        public final Builder certificateDescription(CertificateDescription certificateDescription) {
            this.certificateDescription = certificateDescription;
            return this;
        }

        public final void setCertificateDescription(CertificateDescription.BuilderImpl certificateDescription) {
            this.certificateDescription = certificateDescription != null ? certificateDescription.build() : null;
        }

        @Override
        public DescribeCertificateResponse build() {
            return new DescribeCertificateResponse(this);
        }
    }
}
