/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output for the DescribeThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeThingTypeResponse extends IoTResponse implements
        ToCopyableBuilder<DescribeThingTypeResponse.Builder, DescribeThingTypeResponse> {
    private final String thingTypeName;

    private final ThingTypeProperties thingTypeProperties;

    private final ThingTypeMetadata thingTypeMetadata;

    private DescribeThingTypeResponse(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
        this.thingTypeMetadata = builder.thingTypeMetadata;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The ThingTypeProperties contains information about the thing type including description, and a list of searchable
     * thing attribute names.
     * </p>
     * 
     * @return The ThingTypeProperties contains information about the thing type including description, and a list of
     *         searchable thing attribute names.
     */
    public ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    /**
     * <p>
     * The ThingTypeMetadata contains additional information about the thing type including: creation date and time, a
     * value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
     * </p>
     * 
     * @return The ThingTypeMetadata contains additional information about the thing type including: creation date and
     *         time, a value indicating whether the thing type is deprecated, and a date and time when it was
     *         deprecated.
     */
    public ThingTypeMetadata thingTypeMetadata() {
        return thingTypeMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeProperties());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeMetadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingTypeResponse)) {
            return false;
        }
        DescribeThingTypeResponse other = (DescribeThingTypeResponse) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingTypeProperties(), other.thingTypeProperties())
                && Objects.equals(thingTypeMetadata(), other.thingTypeMetadata());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (thingTypeName() != null) {
            sb.append("ThingTypeName: ").append(thingTypeName()).append(",");
        }
        if (thingTypeProperties() != null) {
            sb.append("ThingTypeProperties: ").append(thingTypeProperties()).append(",");
        }
        if (thingTypeMetadata() != null) {
            sb.append("ThingTypeMetadata: ").append(thingTypeMetadata()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "thingTypeProperties":
            return Optional.of(clazz.cast(thingTypeProperties()));
        case "thingTypeMetadata":
            return Optional.of(clazz.cast(thingTypeMetadata()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, DescribeThingTypeResponse> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The ThingTypeProperties contains information about the thing type including description, and a list of
         * searchable thing attribute names.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties contains information about the thing type including description, and a list of
         *        searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);

        /**
         * <p>
         * The ThingTypeProperties contains information about the thing type including description, and a list of
         * searchable thing attribute names.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingTypeProperties.Builder} avoiding the need
         * to create one manually via {@link ThingTypeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingTypeProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingTypeProperties(ThingTypeProperties)}.
         * 
         * @param thingTypeProperties
         *        a consumer that will call methods on {@link ThingTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeProperties(ThingTypeProperties)
         */
        default Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return thingTypeProperties(ThingTypeProperties.builder().apply(thingTypeProperties).build());
        }

        /**
         * <p>
         * The ThingTypeMetadata contains additional information about the thing type including: creation date and time,
         * a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
         * </p>
         * 
         * @param thingTypeMetadata
         *        The ThingTypeMetadata contains additional information about the thing type including: creation date
         *        and time, a value indicating whether the thing type is deprecated, and a date and time when it was
         *        deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata);

        /**
         * <p>
         * The ThingTypeMetadata contains additional information about the thing type including: creation date and time,
         * a value indicating whether the thing type is deprecated, and a date and time when it was deprecated.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingTypeMetadata.Builder} avoiding the need to
         * create one manually via {@link ThingTypeMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingTypeMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #thingTypeMetadata(ThingTypeMetadata)}.
         * 
         * @param thingTypeMetadata
         *        a consumer that will call methods on {@link ThingTypeMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeMetadata(ThingTypeMetadata)
         */
        default Builder thingTypeMetadata(Consumer<ThingTypeMetadata.Builder> thingTypeMetadata) {
            return thingTypeMetadata(ThingTypeMetadata.builder().apply(thingTypeMetadata).build());
        }
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String thingTypeName;

        private ThingTypeProperties thingTypeProperties;

        private ThingTypeMetadata thingTypeMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingTypeResponse model) {
            thingTypeName(model.thingTypeName);
            thingTypeProperties(model.thingTypeProperties);
            thingTypeMetadata(model.thingTypeMetadata);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return thingTypeProperties != null ? thingTypeProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        public final ThingTypeMetadata.Builder getThingTypeMetadata() {
            return thingTypeMetadata != null ? thingTypeMetadata.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeMetadata(ThingTypeMetadata thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata;
            return this;
        }

        public final void setThingTypeMetadata(ThingTypeMetadata.BuilderImpl thingTypeMetadata) {
            this.thingTypeMetadata = thingTypeMetadata != null ? thingTypeMetadata.build() : null;
        }

        @Override
        public DescribeThingTypeResponse build() {
            return new DescribeThingTypeResponse(this);
        }
    }
}
