/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the DetachThingPrincipal operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DetachThingPrincipalRequest extends IoTRequest implements
        ToCopyableBuilder<DetachThingPrincipalRequest.Builder, DetachThingPrincipalRequest> {
    private final String thingName;

    private final String principal;

    private DetachThingPrincipalRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The name of the thing.
     * </p>
     * 
     * @return The name of the thing.
     */
    public String thingName() {
        return thingName;
    }

    /**
     * <p>
     * If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon
     * Cognito identity, this value must be the ID of the Amazon Cognito identity.
     * </p>
     * 
     * @return If the principal is a certificate, this value must be ARN of the certificate. If the principal is an
     *         Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.
     */
    public String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingName());
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetachThingPrincipalRequest)) {
            return false;
        }
        DetachThingPrincipalRequest other = (DetachThingPrincipalRequest) obj;
        return Objects.equals(thingName(), other.thingName()) && Objects.equals(principal(), other.principal());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (thingName() != null) {
            sb.append("ThingName: ").append(thingName()).append(",");
        }
        if (principal() != null) {
            sb.append("Principal: ").append(principal()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingName":
            return Optional.of(clazz.cast(thingName()));
        case "principal":
            return Optional.of(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, DetachThingPrincipalRequest> {
        /**
         * <p>
         * The name of the thing.
         * </p>
         * 
         * @param thingName
         *        The name of the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingName(String thingName);

        /**
         * <p>
         * If the principal is a certificate, this value must be ARN of the certificate. If the principal is an Amazon
         * Cognito identity, this value must be the ID of the Amazon Cognito identity.
         * </p>
         * 
         * @param principal
         *        If the principal is a certificate, this value must be ARN of the certificate. If the principal is an
         *        Amazon Cognito identity, this value must be the ID of the Amazon Cognito identity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String thingName;

        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(DetachThingPrincipalRequest model) {
            thingName(model.thingName);
            principal(model.principal);
        }

        public final String getThingName() {
            return thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DetachThingPrincipalRequest build() {
            return new DetachThingPrincipalRequest(this);
        }
    }
}
