/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.FirehoseActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action that writes data to an Amazon Kinesis Firehose stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FirehoseAction implements StructuredPojo, ToCopyableBuilder<FirehoseAction.Builder, FirehoseAction> {
    private final String roleArn;

    private final String deliveryStreamName;

    private final String separator;

    private FirehoseAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.deliveryStreamName = builder.deliveryStreamName;
        this.separator = builder.separator;
    }

    /**
     * <p>
     * The IAM role that grants access to the Amazon Kinesis Firehost stream.
     * </p>
     * 
     * @return The IAM role that grants access to the Amazon Kinesis Firehost stream.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The delivery stream name.
     * </p>
     * 
     * @return The delivery stream name.
     */
    public String deliveryStreamName() {
        return deliveryStreamName;
    }

    /**
     * <p>
     * A character separator that will be used to separate records written to the Firehose stream. Valid values are:
     * '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     * </p>
     * 
     * @return A character separator that will be used to separate records written to the Firehose stream. Valid values
     *         are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
     */
    public String separator() {
        return separator;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(deliveryStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(separator());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirehoseAction)) {
            return false;
        }
        FirehoseAction other = (FirehoseAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(deliveryStreamName(), other.deliveryStreamName())
                && Objects.equals(separator(), other.separator());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (deliveryStreamName() != null) {
            sb.append("DeliveryStreamName: ").append(deliveryStreamName()).append(",");
        }
        if (separator() != null) {
            sb.append("Separator: ").append(separator()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "deliveryStreamName":
            return Optional.of(clazz.cast(deliveryStreamName()));
        case "separator":
            return Optional.of(clazz.cast(separator()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FirehoseActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, FirehoseAction> {
        /**
         * <p>
         * The IAM role that grants access to the Amazon Kinesis Firehost stream.
         * </p>
         * 
         * @param roleArn
         *        The IAM role that grants access to the Amazon Kinesis Firehost stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The delivery stream name.
         * </p>
         * 
         * @param deliveryStreamName
         *        The delivery stream name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deliveryStreamName(String deliveryStreamName);

        /**
         * <p>
         * A character separator that will be used to separate records written to the Firehose stream. Valid values are:
         * '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * </p>
         * 
         * @param separator
         *        A character separator that will be used to separate records written to the Firehose stream. Valid
         *        values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder separator(String separator);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String deliveryStreamName;

        private String separator;

        private BuilderImpl() {
        }

        private BuilderImpl(FirehoseAction model) {
            roleArn(model.roleArn);
            deliveryStreamName(model.deliveryStreamName);
            separator(model.separator);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getDeliveryStreamName() {
            return deliveryStreamName;
        }

        @Override
        public final Builder deliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
            return this;
        }

        public final void setDeliveryStreamName(String deliveryStreamName) {
            this.deliveryStreamName = deliveryStreamName;
        }

        public final String getSeparator() {
            return separator;
        }

        @Override
        public final Builder separator(String separator) {
            this.separator = separator;
            return this;
        }

        public final void setSeparator(String separator) {
            this.separator = separator;
        }

        @Override
        public FirehoseAction build() {
            return new FirehoseAction(this);
        }
    }
}
