/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the GetPolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetPolicyResponse extends IoTResponse implements ToCopyableBuilder<GetPolicyResponse.Builder, GetPolicyResponse> {
    private final String policyName;

    private final String policyArn;

    private final String policyDocument;

    private final String defaultVersionId;

    private GetPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyArn = builder.policyArn;
        this.policyDocument = builder.policyDocument;
        this.defaultVersionId = builder.defaultVersionId;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy ARN.
     * </p>
     * 
     * @return The policy ARN.
     */
    public String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The JSON document that describes the policy.
     * </p>
     * 
     * @return The JSON document that describes the policy.
     */
    public String policyDocument() {
        return policyDocument;
    }

    /**
     * <p>
     * The default policy version ID.
     * </p>
     * 
     * @return The default policy version ID.
     */
    public String defaultVersionId() {
        return defaultVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(defaultVersionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyResponse)) {
            return false;
        }
        GetPolicyResponse other = (GetPolicyResponse) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(policyDocument(), other.policyDocument())
                && Objects.equals(defaultVersionId(), other.defaultVersionId());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (policyName() != null) {
            sb.append("PolicyName: ").append(policyName()).append(",");
        }
        if (policyArn() != null) {
            sb.append("PolicyArn: ").append(policyArn()).append(",");
        }
        if (policyDocument() != null) {
            sb.append("PolicyDocument: ").append(policyDocument()).append(",");
        }
        if (defaultVersionId() != null) {
            sb.append("DefaultVersionId: ").append(defaultVersionId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        case "policyArn":
            return Optional.of(clazz.cast(policyArn()));
        case "policyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        case "defaultVersionId":
            return Optional.of(clazz.cast(defaultVersionId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, GetPolicyResponse> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy ARN.
         * </p>
         * 
         * @param policyArn
         *        The policy ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The JSON document that describes the policy.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        /**
         * <p>
         * The default policy version ID.
         * </p>
         * 
         * @param defaultVersionId
         *        The default policy version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultVersionId(String defaultVersionId);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private String policyName;

        private String policyArn;

        private String policyDocument;

        private String defaultVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyResponse model) {
            policyName(model.policyName);
            policyArn(model.policyArn);
            policyDocument(model.policyDocument);
            defaultVersionId(model.defaultVersionId);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        public final String getDefaultVersionId() {
            return defaultVersionId;
        }

        @Override
        public final Builder defaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
            return this;
        }

        public final void setDefaultVersionId(String defaultVersionId) {
            this.defaultVersionId = defaultVersionId;
        }

        @Override
        public GetPolicyResponse build() {
            return new GetPolicyResponse(this);
        }
    }
}
