/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KeyPairMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a key pair.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class KeyPair implements StructuredPojo, ToCopyableBuilder<KeyPair.Builder, KeyPair> {
    private final String publicKey;

    private final String privateKey;

    private KeyPair(BuilderImpl builder) {
        this.publicKey = builder.publicKey;
        this.privateKey = builder.privateKey;
    }

    /**
     * <p>
     * The public key.
     * </p>
     * 
     * @return The public key.
     */
    public String publicKey() {
        return publicKey;
    }

    /**
     * <p>
     * The private key.
     * </p>
     * 
     * @return The private key.
     */
    public String privateKey() {
        return privateKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyPair)) {
            return false;
        }
        KeyPair other = (KeyPair) obj;
        return Objects.equals(publicKey(), other.publicKey()) && Objects.equals(privateKey(), other.privateKey());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (publicKey() != null) {
            sb.append("PublicKey: ").append(publicKey()).append(",");
        }
        if (privateKey() != null) {
            sb.append("PrivateKey: ").append(privateKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKey":
            return Optional.of(clazz.cast(publicKey()));
        case "PrivateKey":
            return Optional.of(clazz.cast(privateKey()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KeyPairMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, KeyPair> {
        /**
         * <p>
         * The public key.
         * </p>
         * 
         * @param publicKey
         *        The public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);

        /**
         * <p>
         * The private key.
         * </p>
         * 
         * @param privateKey
         *        The private key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);
    }

    static final class BuilderImpl implements Builder {
        private String publicKey;

        private String privateKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyPair model) {
            publicKey(model.publicKey);
            privateKey(model.privateKey);
        }

        public final String getPublicKey() {
            return publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        @Override
        public KeyPair build() {
            return new KeyPair(this);
        }
    }
}
