/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the ListPrincipalPolicies operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListPrincipalPoliciesRequest extends IoTRequest implements
        ToCopyableBuilder<ListPrincipalPoliciesRequest.Builder, ListPrincipalPoliciesRequest> {
    private final String principal;

    private final String marker;

    private final Integer pageSize;

    private final Boolean ascendingOrder;

    private ListPrincipalPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.principal = builder.principal;
        this.marker = builder.marker;
        this.pageSize = builder.pageSize;
        this.ascendingOrder = builder.ascendingOrder;
    }

    /**
     * <p>
     * The principal.
     * </p>
     * 
     * @return The principal.
     */
    public String principal() {
        return principal;
    }

    /**
     * <p>
     * The marker for the next set of results.
     * </p>
     * 
     * @return The marker for the next set of results.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The result page size.
     * </p>
     * 
     * @return The result page size.
     */
    public Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * Specifies the order for results. If true, results are returned in ascending creation order.
     * </p>
     * 
     * @return Specifies the order for results. If true, results are returned in ascending creation order.
     */
    public Boolean ascendingOrder() {
        return ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(ascendingOrder());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPrincipalPoliciesRequest)) {
            return false;
        }
        ListPrincipalPoliciesRequest other = (ListPrincipalPoliciesRequest) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(marker(), other.marker())
                && Objects.equals(pageSize(), other.pageSize()) && Objects.equals(ascendingOrder(), other.ascendingOrder());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (principal() != null) {
            sb.append("Principal: ").append(principal()).append(",");
        }
        if (marker() != null) {
            sb.append("Marker: ").append(marker()).append(",");
        }
        if (pageSize() != null) {
            sb.append("PageSize: ").append(pageSize()).append(",");
        }
        if (ascendingOrder() != null) {
            sb.append("AscendingOrder: ").append(ascendingOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principal":
            return Optional.of(clazz.cast(principal()));
        case "marker":
            return Optional.of(clazz.cast(marker()));
        case "pageSize":
            return Optional.of(clazz.cast(pageSize()));
        case "ascendingOrder":
            return Optional.of(clazz.cast(ascendingOrder()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, ListPrincipalPoliciesRequest> {
        /**
         * <p>
         * The principal.
         * </p>
         * 
         * @param principal
         *        The principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);

        /**
         * <p>
         * The marker for the next set of results.
         * </p>
         * 
         * @param marker
         *        The marker for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The result page size.
         * </p>
         * 
         * @param pageSize
         *        The result page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * Specifies the order for results. If true, results are returned in ascending creation order.
         * </p>
         * 
         * @param ascendingOrder
         *        Specifies the order for results. If true, results are returned in ascending creation order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ascendingOrder(Boolean ascendingOrder);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String principal;

        private String marker;

        private Integer pageSize;

        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPrincipalPoliciesRequest model) {
            principal(model.principal);
            marker(model.marker);
            pageSize(model.pageSize);
            ascendingOrder(model.ascendingOrder);
        }

        public final String getPrincipal() {
            return principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final Boolean getAscendingOrder() {
            return ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListPrincipalPoliciesRequest build() {
            return new ListPrincipalPoliciesRequest(this);
        }
    }
}
