/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.RepublishActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to republish to another topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class RepublishAction implements StructuredPojo, ToCopyableBuilder<RepublishAction.Builder, RepublishAction> {
    private final String roleArn;

    private final String topic;

    private RepublishAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.topic = builder.topic;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public String topic() {
        return topic;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepublishAction)) {
            return false;
        }
        RepublishAction other = (RepublishAction) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(topic(), other.topic());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "topic":
            return Optional.of(clazz.cast(topic()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepublishActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, RepublishAction> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String topic;

        private BuilderImpl() {
        }

        private BuilderImpl(RepublishAction model) {
            roleArn(model.roleArn);
            topic(model.topic);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public RepublishAction build() {
            return new RepublishAction(this);
        }
    }
}
