/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SalesforceActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write a message to a Salesforce IoT Cloud Input Stream.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SalesforceAction implements StructuredPojo, ToCopyableBuilder<SalesforceAction.Builder, SalesforceAction> {
    private final String token;

    private final String url;

    private SalesforceAction(BuilderImpl builder) {
        this.token = builder.token;
        this.url = builder.url;
    }

    /**
     * <p>
     * The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from the
     * Salesforce IoT Cloud platform after creation of the Input Stream.
     * </p>
     * 
     * @return The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available
     *         from the Salesforce IoT Cloud platform after creation of the Input Stream.
     */
    public String token() {
        return token;
    }

    /**
     * <p>
     * The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud
     * platform after creation of the Input Stream.
     * </p>
     * 
     * @return The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT
     *         Cloud platform after creation of the Input Stream.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(token());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceAction)) {
            return false;
        }
        SalesforceAction other = (SalesforceAction) obj;
        return Objects.equals(token(), other.token()) && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (token() != null) {
            sb.append("Token: ").append(token()).append(",");
        }
        if (url() != null) {
            sb.append("Url: ").append(url()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "token":
            return Optional.of(clazz.cast(token()));
        case "url":
            return Optional.of(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SalesforceActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SalesforceAction> {
        /**
         * <p>
         * The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available from
         * the Salesforce IoT Cloud platform after creation of the Input Stream.
         * </p>
         * 
         * @param token
         *        The token used to authenticate access to the Salesforce IoT Cloud Input Stream. The token is available
         *        from the Salesforce IoT Cloud platform after creation of the Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder token(String token);

        /**
         * <p>
         * The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT Cloud
         * platform after creation of the Input Stream.
         * </p>
         * 
         * @param url
         *        The URL exposed by the Salesforce IoT Cloud Input Stream. The URL is available from the Salesforce IoT
         *        Cloud platform after creation of the Input Stream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl implements Builder {
        private String token;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceAction model) {
            token(model.token);
            url(model.url);
        }

        public final String getToken() {
            return token;
        }

        @Override
        public final Builder token(String token) {
            this.token = token;
            return this;
        }

        public final void setToken(String token) {
            this.token = token;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public SalesforceAction build() {
            return new SalesforceAction(this);
        }
    }
}
