/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.SnsActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to publish to an Amazon SNS topic.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class SnsAction implements StructuredPojo, ToCopyableBuilder<SnsAction.Builder, SnsAction> {
    private final String targetArn;

    private final String roleArn;

    private final String messageFormat;

    private SnsAction(BuilderImpl builder) {
        this.targetArn = builder.targetArn;
        this.roleArn = builder.roleArn;
        this.messageFormat = builder.messageFormat;
    }

    /**
     * <p>
     * The ARN of the SNS topic.
     * </p>
     * 
     * @return The ARN of the SNS topic.
     */
    public String targetArn() {
        return targetArn;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default value
     * of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant
     * platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html"
     * >http://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageFormatString}.
     * </p>
     * 
     * @return The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
     *         value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
     *         relevant platform-specific bits of the payload should be extracted. To read more about SNS message
     *         formats, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com
     *         /sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * @see MessageFormat
     */
    public MessageFormat messageFormat() {
        return MessageFormat.fromValue(messageFormat);
    }

    /**
     * <p>
     * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default value
     * of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant
     * platform-specific bits of the payload should be extracted. To read more about SNS message formats, see <a
     * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html"
     * >http://docs.aws.amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #messageFormat}
     * will return {@link MessageFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #messageFormatString}.
     * </p>
     * 
     * @return The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
     *         value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
     *         relevant platform-specific bits of the payload should be extracted. To read more about SNS message
     *         formats, see <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com
     *         /sns/latest/dg/json-formats.html</a> refer to their official documentation.
     * @see MessageFormat
     */
    public String messageFormatString() {
        return messageFormat;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetArn());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(messageFormatString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnsAction)) {
            return false;
        }
        SnsAction other = (SnsAction) obj;
        return Objects.equals(targetArn(), other.targetArn()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(messageFormatString(), other.messageFormatString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (targetArn() != null) {
            sb.append("TargetArn: ").append(targetArn()).append(",");
        }
        if (roleArn() != null) {
            sb.append("RoleArn: ").append(roleArn()).append(",");
        }
        if (messageFormatString() != null) {
            sb.append("MessageFormat: ").append(messageFormatString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetArn":
            return Optional.of(clazz.cast(targetArn()));
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "messageFormat":
            return Optional.of(clazz.cast(messageFormatString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SnsActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, SnsAction> {
        /**
         * <p>
         * The ARN of the SNS topic.
         * </p>
         * 
         * @param targetArn
         *        The ARN of the SNS topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetArn(String targetArn);

        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
         * value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
         * relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats,
         * see <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com/sns/latest
         * /dg/json-formats.html</a> refer to their official documentation.
         * </p>
         * 
         * @param messageFormat
         *        The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The
         *        default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be
         *        parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS
         *        message formats, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws
         *        .amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
         * @see MessageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormat
         */
        Builder messageFormat(String messageFormat);

        /**
         * <p>
         * The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The default
         * value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and
         * relevant platform-specific bits of the payload should be extracted. To read more about SNS message formats,
         * see <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws.amazon.com/sns/latest
         * /dg/json-formats.html</a> refer to their official documentation.
         * </p>
         * 
         * @param messageFormat
         *        The message format of the message to publish. Optional. Accepted values are "JSON" and "RAW". The
         *        default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be
         *        parsed and relevant platform-specific bits of the payload should be extracted. To read more about SNS
         *        message formats, see <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/json-formats.html">http://docs.aws
         *        .amazon.com/sns/latest/dg/json-formats.html</a> refer to their official documentation.
         * @see MessageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MessageFormat
         */
        Builder messageFormat(MessageFormat messageFormat);
    }

    static final class BuilderImpl implements Builder {
        private String targetArn;

        private String roleArn;

        private String messageFormat;

        private BuilderImpl() {
        }

        private BuilderImpl(SnsAction model) {
            targetArn(model.targetArn);
            roleArn(model.roleArn);
            messageFormat(model.messageFormat);
        }

        public final String getTargetArn() {
            return targetArn;
        }

        @Override
        public final Builder targetArn(String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        public final void setTargetArn(String targetArn) {
            this.targetArn = targetArn;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getMessageFormat() {
            return messageFormat;
        }

        @Override
        public final Builder messageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
            return this;
        }

        @Override
        public final Builder messageFormat(MessageFormat messageFormat) {
            this.messageFormat(messageFormat.toString());
            return this;
        }

        public final void setMessageFormat(String messageFormat) {
            this.messageFormat = messageFormat;
        }

        @Override
        public SnsAction build() {
            return new SnsAction(this);
        }
    }
}
