/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotdataplane.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.core.runtime.StandardMemberCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the Publish operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class PublishRequest extends IoTDataPlaneRequest implements ToCopyableBuilder<PublishRequest.Builder, PublishRequest> {
    private final String topic;

    private final Integer qos;

    private final ByteBuffer payload;

    private PublishRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.qos = builder.qos;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The name of the MQTT topic.
     * </p>
     * 
     * @return The name of the MQTT topic.
     */
    public String topic() {
        return topic;
    }

    /**
     * <p>
     * The Quality of Service (QoS) level.
     * </p>
     * 
     * @return The Quality of Service (QoS) level.
     */
    public Integer qos() {
        return qos;
    }

    /**
     * <p>
     * The state information, in JSON format.
     * </p>
     * <p>
     * This method will return a new read-only {@code ByteBuffer} each time it is invoked.
     * </p>
     * 
     * @return The state information, in JSON format.
     */
    public ByteBuffer payload() {
        return payload == null ? null : payload.asReadOnlyBuffer();
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(topic());
        hashCode = 31 * hashCode + Objects.hashCode(qos());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PublishRequest)) {
            return false;
        }
        PublishRequest other = (PublishRequest) obj;
        return Objects.equals(topic(), other.topic()) && Objects.equals(qos(), other.qos())
                && Objects.equals(payload(), other.payload());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (topic() != null) {
            sb.append("Topic: ").append(topic()).append(",");
        }
        if (qos() != null) {
            sb.append("Qos: ").append(qos()).append(",");
        }
        if (payload() != null) {
            sb.append("Payload: ").append(payload()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "topic":
            return Optional.of(clazz.cast(topic()));
        case "qos":
            return Optional.of(clazz.cast(qos()));
        case "payload":
            return Optional.of(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTDataPlaneRequest.Builder, CopyableBuilder<Builder, PublishRequest> {
        /**
         * <p>
         * The name of the MQTT topic.
         * </p>
         * 
         * @param topic
         *        The name of the MQTT topic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topic(String topic);

        /**
         * <p>
         * The Quality of Service (QoS) level.
         * </p>
         * 
         * @param qos
         *        The Quality of Service (QoS) level.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qos(Integer qos);

        /**
         * <p>
         * The state information, in JSON format.
         * </p>
         * <p>
         * To preserve immutability, the remaining bytes in the provided buffer will be copied into a new buffer when
         * set.
         * </p>
         *
         * @param payload
         *        The state information, in JSON format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(ByteBuffer payload);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTDataPlaneRequest.BuilderImpl implements Builder {
        private String topic;

        private Integer qos;

        private ByteBuffer payload;

        private BuilderImpl() {
        }

        private BuilderImpl(PublishRequest model) {
            topic(model.topic);
            qos(model.qos);
            payload(model.payload);
        }

        public final String getTopic() {
            return topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getQos() {
            return qos;
        }

        @Override
        public final Builder qos(Integer qos) {
            this.qos = qos;
            return this;
        }

        public final void setQos(Integer qos) {
            this.qos = qos;
        }

        public final ByteBuffer getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
            return this;
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload = StandardMemberCopier.copy(payload);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PublishRequest build() {
            return new PublishRequest(this);
        }
    }
}
