/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CloudwatchAlarmActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudwatchAlarmAction
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudwatchAlarmAction> {
    private final String roleArn;
    private final String alarmName;
    private final String stateReason;
    private final String stateValue;

    private CloudwatchAlarmAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.alarmName = builder.alarmName;
        this.stateReason = builder.stateReason;
        this.stateValue = builder.stateValue;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public String stateReason() {
        return this.stateReason;
    }

    public String stateValue() {
        return this.stateValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchAlarmAction)) {
            return false;
        }
        CloudwatchAlarmAction other = (CloudwatchAlarmAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.stateReason(), other.stateReason()) && Objects.equals(this.stateValue(), other.stateValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.stateReason() != null) {
            sb.append("StateReason: ").append(this.stateReason()).append(",");
        }
        if (this.stateValue() != null) {
            sb.append("StateValue: ").append(this.stateValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "alarmName": {
                return Optional.of(clazz.cast(this.alarmName()));
            }
            case "stateReason": {
                return Optional.of(clazz.cast(this.stateReason()));
            }
            case "stateValue": {
                return Optional.of(clazz.cast(this.stateValue()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudwatchAlarmActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String alarmName;
        private String stateReason;
        private String stateValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchAlarmAction model) {
            this.roleArn(model.roleArn);
            this.alarmName(model.alarmName);
            this.stateReason(model.stateReason);
            this.stateValue(model.stateValue);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getStateValue() {
            return this.stateValue;
        }

        @Override
        public final Builder stateValue(String stateValue) {
            this.stateValue = stateValue;
            return this;
        }

        public final void setStateValue(String stateValue) {
            this.stateValue = stateValue;
        }

        public CloudwatchAlarmAction build() {
            return new CloudwatchAlarmAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudwatchAlarmAction> {
        public Builder roleArn(String var1);

        public Builder alarmName(String var1);

        public Builder stateReason(String var1);

        public Builder stateValue(String var1);
    }
}

