/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.KinesisActionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class KinesisAction
implements StructuredPojo,
ToCopyableBuilder<Builder, KinesisAction> {
    private final String roleArn;
    private final String streamName;
    private final String partitionKey;

    private KinesisAction(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.streamName = builder.streamName;
        this.partitionKey = builder.partitionKey;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String streamName() {
        return this.streamName;
    }

    public String partitionKey() {
        return this.partitionKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.streamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionKey());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KinesisAction)) {
            return false;
        }
        KinesisAction other = (KinesisAction)obj;
        return Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.streamName(), other.streamName()) && Objects.equals(this.partitionKey(), other.partitionKey());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.roleArn() != null) {
            sb.append("RoleArn: ").append(this.roleArn()).append(",");
        }
        if (this.streamName() != null) {
            sb.append("StreamName: ").append(this.streamName()).append(",");
        }
        if (this.partitionKey() != null) {
            sb.append("PartitionKey: ").append(this.partitionKey()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "roleArn": {
                return Optional.of(clazz.cast(this.roleArn()));
            }
            case "streamName": {
                return Optional.of(clazz.cast(this.streamName()));
            }
            case "partitionKey": {
                return Optional.of(clazz.cast(this.partitionKey()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        KinesisActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String roleArn;
        private String streamName;
        private String partitionKey;

        private BuilderImpl() {
        }

        private BuilderImpl(KinesisAction model) {
            this.roleArn(model.roleArn);
            this.streamName(model.streamName);
            this.partitionKey(model.partitionKey);
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getStreamName() {
            return this.streamName;
        }

        @Override
        public final Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public final void setStreamName(String streamName) {
            this.streamName = streamName;
        }

        public final String getPartitionKey() {
            return this.partitionKey;
        }

        @Override
        public final Builder partitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
            return this;
        }

        public final void setPartitionKey(String partitionKey) {
            this.partitionKey = partitionKey;
        }

        public KinesisAction build() {
            return new KinesisAction(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, KinesisAction> {
        public Builder roleArn(String var1);

        public Builder streamName(String var1);

        public Builder partitionKey(String var1);
    }
}

