/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesByCARequest
extends IoTRequest
implements ToCopyableBuilder<Builder, ListCertificatesByCARequest> {
    private final String caCertificateId;
    private final Integer pageSize;
    private final String marker;
    private final Boolean ascendingOrder;

    private ListCertificatesByCARequest(BuilderImpl builder) {
        super(builder);
        this.caCertificateId = builder.caCertificateId;
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    public String caCertificateId() {
        return this.caCertificateId;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascendingOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesByCARequest)) {
            return false;
        }
        ListCertificatesByCARequest other = (ListCertificatesByCARequest)((Object)obj);
        return Objects.equals(this.caCertificateId(), other.caCertificateId()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.ascendingOrder(), other.ascendingOrder());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.caCertificateId() != null) {
            sb.append("CaCertificateId: ").append(this.caCertificateId()).append(",");
        }
        if (this.pageSize() != null) {
            sb.append("PageSize: ").append(this.pageSize()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.ascendingOrder() != null) {
            sb.append("AscendingOrder: ").append(this.ascendingOrder()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "caCertificateId": {
                return Optional.of(clazz.cast(this.caCertificateId()));
            }
            case "pageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ascendingOrder": {
                return Optional.of(clazz.cast(this.ascendingOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String caCertificateId;
        private Integer pageSize;
        private String marker;
        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesByCARequest model) {
            this.caCertificateId(model.caCertificateId);
            this.pageSize(model.pageSize);
            this.marker(model.marker);
            this.ascendingOrder(model.ascendingOrder);
        }

        public final String getCaCertificateId() {
            return this.caCertificateId;
        }

        @Override
        public final Builder caCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
            return this;
        }

        public final void setCaCertificateId(String caCertificateId) {
            this.caCertificateId = caCertificateId;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return this.ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCertificatesByCARequest build() {
            return new ListCertificatesByCARequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, ListCertificatesByCARequest> {
        public Builder caCertificateId(String var1);

        public Builder pageSize(Integer var1);

        public Builder marker(String var1);

        public Builder ascendingOrder(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

