/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.services.iot.model.ThingAttribute;
import software.amazon.awssdk.services.iot.model.ThingAttributeListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListThingsResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, ListThingsResponse> {
    private final List<ThingAttribute> things;
    private final String nextToken;

    private ListThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    public List<ThingAttribute> things() {
        return this.things;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.things());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingsResponse)) {
            return false;
        }
        ListThingsResponse other = (ListThingsResponse)((Object)obj);
        return Objects.equals(this.things(), other.things()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.things() != null) {
            sb.append("Things: ").append(this.things()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "things": {
                return Optional.of(clazz.cast(this.things()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private List<ThingAttribute> things;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingsResponse model) {
            this.things(model.things);
            this.nextToken(model.nextToken);
        }

        public final Collection<ThingAttribute.Builder> getThings() {
            return this.things != null ? (Collection)this.things.stream().map(ThingAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<ThingAttribute> things) {
            this.things = ThingAttributeListCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(ThingAttribute ... things) {
            this.things(Arrays.asList(things));
            return this;
        }

        public final void setThings(Collection<ThingAttribute.BuilderImpl> things) {
            this.things = ThingAttributeListCopier.copyFromBuilder(things);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListThingsResponse build() {
            return new ListThingsResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, ListThingsResponse> {
        public Builder things(Collection<ThingAttribute> var1);

        public Builder things(ThingAttribute ... var1);

        public Builder nextToken(String var1);
    }
}

