/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListTopicRulesRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, ListTopicRulesRequest> {
    private final String topic;
    private final Integer maxResults;
    private final String nextToken;
    private final Boolean ruleDisabled;

    private ListTopicRulesRequest(BuilderImpl builder) {
        super(builder);
        this.topic = builder.topic;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.ruleDisabled = builder.ruleDisabled;
    }

    public String topic() {
        return this.topic;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.topic());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDisabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTopicRulesRequest)) {
            return false;
        }
        ListTopicRulesRequest other = (ListTopicRulesRequest)((Object)obj);
        return Objects.equals(this.topic(), other.topic()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.ruleDisabled(), other.ruleDisabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.topic() != null) {
            sb.append("Topic: ").append(this.topic()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(this.ruleDisabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topic": {
                return Optional.of(clazz.cast(this.topic()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "ruleDisabled": {
                return Optional.of(clazz.cast(this.ruleDisabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String topic;
        private Integer maxResults;
        private String nextToken;
        private Boolean ruleDisabled;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTopicRulesRequest model) {
            this.topic(model.topic);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.ruleDisabled(model.ruleDisabled);
        }

        public final String getTopic() {
            return this.topic;
        }

        @Override
        public final Builder topic(String topic) {
            this.topic = topic;
            return this;
        }

        public final void setTopic(String topic) {
            this.topic = topic;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListTopicRulesRequest build() {
            return new ListTopicRulesRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, ListTopicRulesRequest> {
        public Builder topic(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder ruleDisabled(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

