/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.Action;
import software.amazon.awssdk.services.iot.model.ActionListCopier;
import software.amazon.awssdk.services.iot.transform.TopicRulePayloadMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TopicRulePayload
implements StructuredPojo,
ToCopyableBuilder<Builder, TopicRulePayload> {
    private final String sql;
    private final String description;
    private final List<Action> actions;
    private final Boolean ruleDisabled;
    private final String awsIotSqlVersion;

    private TopicRulePayload(BuilderImpl builder) {
        this.sql = builder.sql;
        this.description = builder.description;
        this.actions = builder.actions;
        this.ruleDisabled = builder.ruleDisabled;
        this.awsIotSqlVersion = builder.awsIotSqlVersion;
    }

    public String sql() {
        return this.sql;
    }

    public String description() {
        return this.description;
    }

    public List<Action> actions() {
        return this.actions;
    }

    public Boolean ruleDisabled() {
        return this.ruleDisabled;
    }

    public String awsIotSqlVersion() {
        return this.awsIotSqlVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sql());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.actions());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleDisabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsIotSqlVersion());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TopicRulePayload)) {
            return false;
        }
        TopicRulePayload other = (TopicRulePayload)obj;
        return Objects.equals(this.sql(), other.sql()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.ruleDisabled(), other.ruleDisabled()) && Objects.equals(this.awsIotSqlVersion(), other.awsIotSqlVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sql() != null) {
            sb.append("Sql: ").append(this.sql()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.actions() != null) {
            sb.append("Actions: ").append(this.actions()).append(",");
        }
        if (this.ruleDisabled() != null) {
            sb.append("RuleDisabled: ").append(this.ruleDisabled()).append(",");
        }
        if (this.awsIotSqlVersion() != null) {
            sb.append("AwsIotSqlVersion: ").append(this.awsIotSqlVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sql": {
                return Optional.of(clazz.cast(this.sql()));
            }
            case "description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "actions": {
                return Optional.of(clazz.cast(this.actions()));
            }
            case "ruleDisabled": {
                return Optional.of(clazz.cast(this.ruleDisabled()));
            }
            case "awsIotSqlVersion": {
                return Optional.of(clazz.cast(this.awsIotSqlVersion()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TopicRulePayloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String sql;
        private String description;
        private List<Action> actions;
        private Boolean ruleDisabled;
        private String awsIotSqlVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(TopicRulePayload model) {
            this.sql(model.sql);
            this.description(model.description);
            this.actions(model.actions);
            this.ruleDisabled(model.ruleDisabled);
            this.awsIotSqlVersion(model.awsIotSqlVersion);
        }

        public final String getSql() {
            return this.sql;
        }

        @Override
        public final Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public final void setSql(String sql) {
            this.sql = sql;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<Action.Builder> getActions() {
            return this.actions != null ? (Collection)this.actions.stream().map(Action::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder actions(Collection<Action> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Action ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<Action.BuilderImpl> actions) {
            this.actions = ActionListCopier.copyFromBuilder(actions);
        }

        public final Boolean getRuleDisabled() {
            return this.ruleDisabled;
        }

        @Override
        public final Builder ruleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
            return this;
        }

        public final void setRuleDisabled(Boolean ruleDisabled) {
            this.ruleDisabled = ruleDisabled;
        }

        public final String getAwsIotSqlVersion() {
            return this.awsIotSqlVersion;
        }

        @Override
        public final Builder awsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
            return this;
        }

        public final void setAwsIotSqlVersion(String awsIotSqlVersion) {
            this.awsIotSqlVersion = awsIotSqlVersion;
        }

        public TopicRulePayload build() {
            return new TopicRulePayload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TopicRulePayload> {
        public Builder sql(String var1);

        public Builder description(String var1);

        public Builder actions(Collection<Action> var1);

        public Builder actions(Action ... var1);

        public Builder ruleDisabled(Boolean var1);

        public Builder awsIotSqlVersion(String var1);
    }
}

