/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CertificateDescription;

@SdkInternalApi
public class CertificateDescriptionMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").build();
    private static final MarshallingInfo<String> CACERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caCertificateId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").build();
    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").build();
    private static final MarshallingInfo<String> PREVIOUSOWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousOwnedBy").build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").build();
    private static final MarshallingInfo<StructuredPojo> TRANSFERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferData").build();
    private static final CertificateDescriptionMarshaller INSTANCE = new CertificateDescriptionMarshaller();

    public static CertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CertificateDescription certificateDescription, ProtocolMarshaller protocolMarshaller) {
        if (certificateDescription == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)certificateDescription.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.caCertificateId(), CACERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.ownedBy(), OWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.previousOwnedBy(), PREVIOUSOWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.transferData(), TRANSFERDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

