/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;

public class DynamoDBActionUnmarshaller
implements Unmarshaller<DynamoDBAction, JsonUnmarshallerContext> {
    private static final DynamoDBActionUnmarshaller INSTANCE = new DynamoDBActionUnmarshaller();

    public DynamoDBAction unmarshall(JsonUnmarshallerContext context) throws Exception {
        DynamoDBAction.Builder dynamoDBActionBuilder = DynamoDBAction.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("tableName", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.tableName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("roleArn", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.roleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("operation", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.operation((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hashKeyField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyField((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hashKeyValue", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("hashKeyType", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.hashKeyType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("rangeKeyField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyField((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("rangeKeyValue", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyValue((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("rangeKeyType", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.rangeKeyType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("payloadField", targetDepth)) {
                    context.nextToken();
                    dynamoDBActionBuilder.payloadField((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (DynamoDBAction)dynamoDBActionBuilder.build();
    }

    public static DynamoDBActionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

