/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.TopicRule;

@SdkInternalApi
public class TopicRuleMarshaller {
    private static final MarshallingInfo<String> RULENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleName").build();
    private static final MarshallingInfo<String> SQL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sql").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<Instant> CREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("createdAt").build();
    private static final MarshallingInfo<List> ACTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("actions").build();
    private static final MarshallingInfo<Boolean> RULEDISABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleDisabled").build();
    private static final MarshallingInfo<String> AWSIOTSQLVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("awsIotSqlVersion").build();
    private static final TopicRuleMarshaller INSTANCE = new TopicRuleMarshaller();

    public static TopicRuleMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(TopicRule topicRule, ProtocolMarshaller protocolMarshaller) {
        if (topicRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)topicRule.ruleName(), RULENAME_BINDING);
            protocolMarshaller.marshall((Object)topicRule.sql(), SQL_BINDING);
            protocolMarshaller.marshall((Object)topicRule.description(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall((Object)topicRule.createdAt(), CREATEDAT_BINDING);
            protocolMarshaller.marshall(topicRule.actions(), ACTIONS_BINDING);
            protocolMarshaller.marshall((Object)topicRule.ruleDisabled(), RULEDISABLED_BINDING);
            protocolMarshaller.marshall((Object)topicRule.awsIotSqlVersion(), AWSIOTSQLVERSION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

