/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreatePolicy operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreatePolicyRequest extends IoTRequest implements
        ToCopyableBuilder<CreatePolicyRequest.Builder, CreatePolicyRequest> {
    private final String policyName;

    private final String policyDocument;

    private CreatePolicyRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The policy name.
     * </p>
     * 
     * @return The policy name.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a
     * maximum length of 2048, excluding whitespace.
     * </p>
     * 
     * @return The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with
     *         a maximum length of 2048, excluding whitespace.
     */
    public String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePolicyRequest)) {
            return false;
        }
        CreatePolicyRequest other = (CreatePolicyRequest) obj;
        return Objects.equals(policyName(), other.policyName()) && Objects.equals(policyDocument(), other.policyDocument());
    }

    @Override
    public String toString() {
        return ToString.builder("CreatePolicyRequest").add("PolicyName", policyName()).add("PolicyDocument", policyDocument())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyName":
            return Optional.of(clazz.cast(policyName()));
        case "policyDocument":
            return Optional.of(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, CreatePolicyRequest> {
        /**
         * <p>
         * The policy name.
         * </p>
         * 
         * @param policyName
         *        The policy name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1, with a
         * maximum length of 2048, excluding whitespace.
         * </p>
         * 
         * @param policyDocument
         *        The JSON document that describes the policy. <b>policyDocument</b> must have a minimum length of 1,
         *        with a maximum length of 2048, excluding whitespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String policyName;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePolicyRequest model) {
            policyName(model.policyName);
            policyDocument(model.policyDocument);
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreatePolicyRequest build() {
            return new CreatePolicyRequest(this);
        }
    }
}
