/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input for the CreateThingType operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateThingTypeRequest extends IoTRequest implements
        ToCopyableBuilder<CreateThingTypeRequest.Builder, CreateThingTypeRequest> {
    private final String thingTypeName;

    private final ThingTypeProperties thingTypeProperties;

    private CreateThingTypeRequest(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
    }

    /**
     * <p>
     * The name of the thing type.
     * </p>
     * 
     * @return The name of the thing type.
     */
    public String thingTypeName() {
        return thingTypeName;
    }

    /**
     * <p>
     * The ThingTypeProperties for the thing type to create. It contains information about the new thing type including
     * a description, and a list of searchable thing attribute names.
     * </p>
     * 
     * @return The ThingTypeProperties for the thing type to create. It contains information about the new thing type
     *         including a description, and a list of searchable thing attribute names.
     */
    public ThingTypeProperties thingTypeProperties() {
        return thingTypeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(thingTypeProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeRequest)) {
            return false;
        }
        CreateThingTypeRequest other = (CreateThingTypeRequest) obj;
        return Objects.equals(thingTypeName(), other.thingTypeName())
                && Objects.equals(thingTypeProperties(), other.thingTypeProperties());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateThingTypeRequest").add("ThingTypeName", thingTypeName())
                .add("ThingTypeProperties", thingTypeProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "thingTypeName":
            return Optional.of(clazz.cast(thingTypeName()));
        case "thingTypeProperties":
            return Optional.of(clazz.cast(thingTypeProperties()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTRequest.Builder, CopyableBuilder<Builder, CreateThingTypeRequest> {
        /**
         * <p>
         * The name of the thing type.
         * </p>
         * 
         * @param thingTypeName
         *        The name of the thing type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeName(String thingTypeName);

        /**
         * <p>
         * The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         * including a description, and a list of searchable thing attribute names.
         * </p>
         * 
         * @param thingTypeProperties
         *        The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         *        including a description, and a list of searchable thing attribute names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thingTypeProperties(ThingTypeProperties thingTypeProperties);

        /**
         * <p>
         * The ThingTypeProperties for the thing type to create. It contains information about the new thing type
         * including a description, and a list of searchable thing attribute names.
         * </p>
         * This is a convenience that creates an instance of the {@link ThingTypeProperties.Builder} avoiding the need
         * to create one manually via {@link ThingTypeProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThingTypeProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #thingTypeProperties(ThingTypeProperties)}.
         * 
         * @param thingTypeProperties
         *        a consumer that will call methods on {@link ThingTypeProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #thingTypeProperties(ThingTypeProperties)
         */
        default Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return thingTypeProperties(ThingTypeProperties.builder().apply(thingTypeProperties).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends IoTRequest.BuilderImpl implements Builder {
        private String thingTypeName;

        private ThingTypeProperties thingTypeProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeRequest model) {
            thingTypeName(model.thingTypeName);
            thingTypeProperties(model.thingTypeProperties);
        }

        public final String getThingTypeName() {
            return thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return thingTypeProperties != null ? thingTypeProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateThingTypeRequest build() {
            return new CreateThingTypeRequest(this);
        }
    }
}
