/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.S3ActionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action to write data to an Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class S3Action implements StructuredPojo, ToCopyableBuilder<S3Action.Builder, S3Action> {
    private final String roleArn;

    private final String bucketName;

    private final String key;

    private final String cannedAcl;

    private S3Action(BuilderImpl builder) {
        this.roleArn = builder.roleArn;
        this.bucketName = builder.bucketName;
        this.key = builder.key;
        this.cannedAcl = builder.cannedAcl;
    }

    /**
     * <p>
     * The ARN of the IAM role that grants access.
     * </p>
     * 
     * @return The ARN of the IAM role that grants access.
     */
    public String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon S3 bucket.
     * </p>
     * 
     * @return The Amazon S3 bucket.
     */
    public String bucketName() {
        return bucketName;
    }

    /**
     * <p>
     * The object key.
     * </p>
     * 
     * @return The object key.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information,
     * see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cannedAclString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
     *         information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
     *         canned ACLs</a>.
     * @see CannedAccessControlList
     */
    public CannedAccessControlList cannedAcl() {
        return CannedAccessControlList.fromValue(cannedAcl);
    }

    /**
     * <p>
     * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information,
     * see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cannedAcl} will
     * return {@link CannedAccessControlList#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #cannedAclString}.
     * </p>
     * 
     * @return The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
     *         information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
     *         canned ACLs</a>.
     * @see CannedAccessControlList
     */
    public String cannedAclString() {
        return cannedAcl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(bucketName());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(cannedAclString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Action)) {
            return false;
        }
        S3Action other = (S3Action) obj;
        return Objects.equals(roleArn(), other.roleArn()) && Objects.equals(bucketName(), other.bucketName())
                && Objects.equals(key(), other.key()) && Objects.equals(cannedAclString(), other.cannedAclString());
    }

    @Override
    public String toString() {
        return ToString.builder("S3Action").add("RoleArn", roleArn()).add("BucketName", bucketName()).add("Key", key())
                .add("CannedAcl", cannedAclString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleArn":
            return Optional.of(clazz.cast(roleArn()));
        case "bucketName":
            return Optional.of(clazz.cast(bucketName()));
        case "key":
            return Optional.of(clazz.cast(key()));
        case "cannedAcl":
            return Optional.of(clazz.cast(cannedAclString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3ActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, S3Action> {
        /**
         * <p>
         * The ARN of the IAM role that grants access.
         * </p>
         * 
         * @param roleArn
         *        The ARN of the IAM role that grants access.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon S3 bucket.
         * </p>
         * 
         * @param bucketName
         *        The Amazon S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bucketName(String bucketName);

        /**
         * <p>
         * The object key.
         * </p>
         * 
         * @param key
         *        The object key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
         * @see CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(String cannedAcl);

        /**
         * <p>
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         * information, see <a href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3
         * canned ACLs</a>.
         * </p>
         * 
         * @param cannedAcl
         *        The Amazon S3 canned ACL that controls access to the object identified by the object key. For more
         *        information, see <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl">S3 canned ACLs</a>.
         * @see CannedAccessControlList
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CannedAccessControlList
         */
        Builder cannedAcl(CannedAccessControlList cannedAcl);
    }

    static final class BuilderImpl implements Builder {
        private String roleArn;

        private String bucketName;

        private String key;

        private String cannedAcl;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Action model) {
            roleArn(model.roleArn);
            bucketName(model.bucketName);
            key(model.key);
            cannedAcl(model.cannedAcl);
        }

        public final String getRoleArn() {
            return roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getBucketName() {
            return bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getCannedAcl() {
            return cannedAcl;
        }

        @Override
        public final Builder cannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
            return this;
        }

        @Override
        public final Builder cannedAcl(CannedAccessControlList cannedAcl) {
            this.cannedAcl(cannedAcl.toString());
            return this;
        }

        public final void setCannedAcl(String cannedAcl) {
            this.cannedAcl = cannedAcl;
        }

        @Override
        public S3Action build() {
            return new S3Action(this);
        }
    }
}
