/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.transform.AttributePayloadMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AttributePayload
implements StructuredPojo,
ToCopyableBuilder<Builder, AttributePayload> {
    private final Map<String, String> attributes;
    private final Boolean merge;

    private AttributePayload(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.merge = builder.merge;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Boolean merge() {
        return this.merge;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.merge());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AttributePayload)) {
            return false;
        }
        AttributePayload other = (AttributePayload)obj;
        return Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.merge(), other.merge());
    }

    public String toString() {
        return ToString.builder((String)"AttributePayload").add("Attributes", this.attributes()).add("Merge", (Object)this.merge()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "merge": {
                return Optional.of(clazz.cast(this.merge()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AttributePayloadMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> attributes;
        private Boolean merge;

        private BuilderImpl() {
        }

        private BuilderImpl(AttributePayload model) {
            this.attributes(model.attributes);
            this.merge(model.merge);
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Boolean getMerge() {
            return this.merge;
        }

        @Override
        public final Builder merge(Boolean merge) {
            this.merge = merge;
            return this;
        }

        public final void setMerge(Boolean merge) {
            this.merge = merge;
        }

        public AttributePayload build() {
            return new AttributePayload(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AttributePayload> {
        public Builder attributes(Map<String, String> var1);

        public Builder merge(Boolean var1);
    }
}

