/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.services.iot.model.ThingTypeProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateThingTypeRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, CreateThingTypeRequest> {
    private final String thingTypeName;
    private final ThingTypeProperties thingTypeProperties;

    private CreateThingTypeRequest(BuilderImpl builder) {
        super(builder);
        this.thingTypeName = builder.thingTypeName;
        this.thingTypeProperties = builder.thingTypeProperties;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public ThingTypeProperties thingTypeProperties() {
        return this.thingTypeProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeProperties());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThingTypeRequest)) {
            return false;
        }
        CreateThingTypeRequest other = (CreateThingTypeRequest)((Object)obj);
        return Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.thingTypeProperties(), other.thingTypeProperties());
    }

    public String toString() {
        return ToString.builder((String)"CreateThingTypeRequest").add("ThingTypeName", (Object)this.thingTypeName()).add("ThingTypeProperties", (Object)this.thingTypeProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
            case "thingTypeProperties": {
                return Optional.of(clazz.cast(this.thingTypeProperties()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String thingTypeName;
        private ThingTypeProperties thingTypeProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThingTypeRequest model) {
            this.thingTypeName(model.thingTypeName);
            this.thingTypeProperties(model.thingTypeProperties);
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final ThingTypeProperties.Builder getThingTypeProperties() {
            return this.thingTypeProperties != null ? this.thingTypeProperties.toBuilder() : null;
        }

        @Override
        public final Builder thingTypeProperties(ThingTypeProperties thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        public final void setThingTypeProperties(ThingTypeProperties.BuilderImpl thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties != null ? thingTypeProperties.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateThingTypeRequest build() {
            return new CreateThingTypeRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, CreateThingTypeRequest> {
        public Builder thingTypeName(String var1);

        public Builder thingTypeProperties(ThingTypeProperties var1);

        default public Builder thingTypeProperties(Consumer<ThingTypeProperties.Builder> thingTypeProperties) {
            return this.thingTypeProperties((ThingTypeProperties)((ThingTypeProperties.Builder)ThingTypeProperties.builder().apply(thingTypeProperties)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

