/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.iot.model.AttributesCopier;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeThingResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, DescribeThingResponse> {
    private final String defaultClientId;
    private final String thingName;
    private final String thingTypeName;
    private final Map<String, String> attributes;
    private final Long version;

    private DescribeThingResponse(BuilderImpl builder) {
        super(builder);
        this.defaultClientId = builder.defaultClientId;
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributes = builder.attributes;
        this.version = builder.version;
    }

    public String defaultClientId() {
        return this.defaultClientId;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Long version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultClientId());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeThingResponse)) {
            return false;
        }
        DescribeThingResponse other = (DescribeThingResponse)((Object)obj);
        return Objects.equals(this.defaultClientId(), other.defaultClientId()) && Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.attributes(), other.attributes()) && Objects.equals(this.version(), other.version());
    }

    public String toString() {
        return ToString.builder((String)"DescribeThingResponse").add("DefaultClientId", (Object)this.defaultClientId()).add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("Attributes", this.attributes()).add("Version", (Object)this.version()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultClientId": {
                return Optional.of(clazz.cast(this.defaultClientId()));
            }
            case "thingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
            case "attributes": {
                return Optional.of(clazz.cast(this.attributes()));
            }
            case "version": {
                return Optional.of(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private String defaultClientId;
        private String thingName;
        private String thingTypeName;
        private Map<String, String> attributes;
        private Long version;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeThingResponse model) {
            this.defaultClientId(model.defaultClientId);
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributes(model.attributes);
            this.version(model.version);
        }

        public final String getDefaultClientId() {
            return this.defaultClientId;
        }

        @Override
        public final Builder defaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
            return this;
        }

        public final void setDefaultClientId(String defaultClientId) {
            this.defaultClientId = defaultClientId;
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Long getVersion() {
            return this.version;
        }

        @Override
        public final Builder version(Long version) {
            this.version = version;
            return this;
        }

        public final void setVersion(Long version) {
            this.version = version;
        }

        @Override
        public DescribeThingResponse build() {
            return new DescribeThingResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, DescribeThingResponse> {
        public Builder defaultClientId(String var1);

        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributes(Map<String, String> var1);

        public Builder version(Long var1);
    }
}

