/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetPolicyVersionRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, GetPolicyVersionRequest> {
    private final String policyName;
    private final String policyVersionId;

    private GetPolicyVersionRequest(BuilderImpl builder) {
        super(builder);
        this.policyName = builder.policyName;
        this.policyVersionId = builder.policyVersionId;
    }

    public String policyName() {
        return this.policyName;
    }

    public String policyVersionId() {
        return this.policyVersionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionRequest)) {
            return false;
        }
        GetPolicyVersionRequest other = (GetPolicyVersionRequest)((Object)obj);
        return Objects.equals(this.policyName(), other.policyName()) && Objects.equals(this.policyVersionId(), other.policyVersionId());
    }

    public String toString() {
        return ToString.builder((String)"GetPolicyVersionRequest").add("PolicyName", (Object)this.policyName()).add("PolicyVersionId", (Object)this.policyVersionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyName": {
                return Optional.of(clazz.cast(this.policyName()));
            }
            case "policyVersionId": {
                return Optional.of(clazz.cast(this.policyVersionId()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String policyName;
        private String policyVersionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionRequest model) {
            this.policyName(model.policyName);
            this.policyVersionId(model.policyVersionId);
        }

        public final String getPolicyName() {
            return this.policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyVersionId() {
            return this.policyVersionId;
        }

        @Override
        public final Builder policyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
            return this;
        }

        public final void setPolicyVersionId(String policyVersionId) {
            this.policyVersionId = policyVersionId;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public GetPolicyVersionRequest build() {
            return new GetPolicyVersionRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, GetPolicyVersionRequest> {
        public Builder policyName(String var1);

        public Builder policyVersionId(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

