/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.OutgoingCertificateMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OutgoingCertificate
implements StructuredPojo,
ToCopyableBuilder<Builder, OutgoingCertificate> {
    private final String certificateArn;
    private final String certificateId;
    private final String transferredTo;
    private final Instant transferDate;
    private final String transferMessage;
    private final Instant creationDate;

    private OutgoingCertificate(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.transferredTo = builder.transferredTo;
        this.transferDate = builder.transferDate;
        this.transferMessage = builder.transferMessage;
        this.creationDate = builder.creationDate;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String transferredTo() {
        return this.transferredTo;
    }

    public Instant transferDate() {
        return this.transferDate;
    }

    public String transferMessage() {
        return this.transferMessage;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferredTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutgoingCertificate)) {
            return false;
        }
        OutgoingCertificate other = (OutgoingCertificate)obj;
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.transferredTo(), other.transferredTo()) && Objects.equals(this.transferDate(), other.transferDate()) && Objects.equals(this.transferMessage(), other.transferMessage()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"OutgoingCertificate").add("CertificateArn", (Object)this.certificateArn()).add("CertificateId", (Object)this.certificateId()).add("TransferredTo", (Object)this.transferredTo()).add("TransferDate", (Object)this.transferDate()).add("TransferMessage", (Object)this.transferMessage()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateArn": {
                return Optional.of(clazz.cast(this.certificateArn()));
            }
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "transferredTo": {
                return Optional.of(clazz.cast(this.transferredTo()));
            }
            case "transferDate": {
                return Optional.of(clazz.cast(this.transferDate()));
            }
            case "transferMessage": {
                return Optional.of(clazz.cast(this.transferMessage()));
            }
            case "creationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutgoingCertificateMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String certificateArn;
        private String certificateId;
        private String transferredTo;
        private Instant transferDate;
        private String transferMessage;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(OutgoingCertificate model) {
            this.certificateArn(model.certificateArn);
            this.certificateId(model.certificateId);
            this.transferredTo(model.transferredTo);
            this.transferDate(model.transferDate);
            this.transferMessage(model.transferMessage);
            this.creationDate(model.creationDate);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTransferredTo() {
            return this.transferredTo;
        }

        @Override
        public final Builder transferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
            return this;
        }

        public final void setTransferredTo(String transferredTo) {
            this.transferredTo = transferredTo;
        }

        public final Instant getTransferDate() {
            return this.transferDate;
        }

        @Override
        public final Builder transferDate(Instant transferDate) {
            this.transferDate = transferDate;
            return this;
        }

        public final void setTransferDate(Instant transferDate) {
            this.transferDate = transferDate;
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public OutgoingCertificate build() {
            return new OutgoingCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OutgoingCertificate> {
        public Builder certificateArn(String var1);

        public Builder certificateId(String var1);

        public Builder transferredTo(String var1);

        public Builder transferDate(Instant var1);

        public Builder transferMessage(String var1);

        public Builder creationDate(Instant var1);
    }
}

