/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.DynamoDBAction;

@SdkInternalApi
public class DynamoDBActionMarshaller {
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tableName").build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> OPERATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("operation").build();
    private static final MarshallingInfo<String> HASHKEYFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyField").build();
    private static final MarshallingInfo<String> HASHKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyValue").build();
    private static final MarshallingInfo<String> HASHKEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hashKeyType").build();
    private static final MarshallingInfo<String> RANGEKEYFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyField").build();
    private static final MarshallingInfo<String> RANGEKEYVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyValue").build();
    private static final MarshallingInfo<String> RANGEKEYTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("rangeKeyType").build();
    private static final MarshallingInfo<String> PAYLOADFIELD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("payloadField").build();
    private static final DynamoDBActionMarshaller INSTANCE = new DynamoDBActionMarshaller();

    public static DynamoDBActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(DynamoDBAction dynamoDBAction, ProtocolMarshaller protocolMarshaller) {
        if (dynamoDBAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dynamoDBAction.tableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.operation(), OPERATION_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyField(), HASHKEYFIELD_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyValue(), HASHKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.hashKeyTypeString(), HASHKEYTYPE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyField(), RANGEKEYFIELD_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyValue(), RANGEKEYVALUE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.rangeKeyTypeString(), RANGEKEYTYPE_BINDING);
            protocolMarshaller.marshall((Object)dynamoDBAction.payloadField(), PAYLOADFIELD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

