/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.KinesisAction;

@SdkInternalApi
public class KinesisActionMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").build();
    private static final MarshallingInfo<String> STREAMNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("streamName").build();
    private static final MarshallingInfo<String> PARTITIONKEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("partitionKey").build();
    private static final KinesisActionMarshaller INSTANCE = new KinesisActionMarshaller();

    public static KinesisActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KinesisAction kinesisAction, ProtocolMarshaller protocolMarshaller) {
        if (kinesisAction == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kinesisAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)kinesisAction.streamName(), STREAMNAME_BINDING);
            protocolMarshaller.marshall((Object)kinesisAction.partitionKey(), PARTITIONKEY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

