/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import com.fasterxml.jackson.core.JsonToken;
import java.time.Instant;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.iot.model.PolicyVersion;

public class PolicyVersionUnmarshaller
implements Unmarshaller<PolicyVersion, JsonUnmarshallerContext> {
    private static final PolicyVersionUnmarshaller INSTANCE = new PolicyVersionUnmarshaller();

    public PolicyVersion unmarshall(JsonUnmarshallerContext context) throws Exception {
        PolicyVersion.Builder policyVersionBuilder = PolicyVersion.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("versionId", targetDepth)) {
                    context.nextToken();
                    policyVersionBuilder.versionId((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("isDefaultVersion", targetDepth)) {
                    context.nextToken();
                    policyVersionBuilder.isDefaultVersion((Boolean)context.getUnmarshaller(Boolean.class).unmarshall((Object)context));
                }
                if (context.testExpression("createDate", targetDepth)) {
                    context.nextToken();
                    policyVersionBuilder.createDate((Instant)context.getUnmarshaller(Instant.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (PolicyVersion)policyVersionBuilder.build();
    }

    public static PolicyVersionUnmarshaller getInstance() {
        return INSTANCE;
    }
}

