/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.transform.CACertificateDescriptionMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a CA certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CACertificateDescription implements StructuredPojo,
        ToCopyableBuilder<CACertificateDescription.Builder, CACertificateDescription> {
    private final String certificateArn;

    private final String certificateId;

    private final String status;

    private final String certificatePem;

    private final String ownedBy;

    private final Instant creationDate;

    private final String autoRegistrationStatus;

    private CACertificateDescription(BuilderImpl builder) {
        this.certificateArn = builder.certificateArn;
        this.certificateId = builder.certificateId;
        this.status = builder.status;
        this.certificatePem = builder.certificatePem;
        this.ownedBy = builder.ownedBy;
        this.creationDate = builder.creationDate;
        this.autoRegistrationStatus = builder.autoRegistrationStatus;
    }

    /**
     * <p>
     * The CA certificate ARN.
     * </p>
     * 
     * @return The CA certificate ARN.
     */
    public String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The CA certificate ID.
     * </p>
     * 
     * @return The CA certificate ID.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The status of a CA certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of a CA certificate.
     * @see CACertificateStatus
     */
    public CACertificateStatus status() {
        return CACertificateStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a CA certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CACertificateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusString}.
     * </p>
     * 
     * @return The status of a CA certificate.
     * @see CACertificateStatus
     */
    public String statusString() {
        return status;
    }

    /**
     * <p>
     * The CA certificate data, in PEM format.
     * </p>
     * 
     * @return The CA certificate data, in PEM format.
     */
    public String certificatePem() {
        return certificatePem;
    }

    /**
     * <p>
     * The owner of the CA certificate.
     * </p>
     * 
     * @return The owner of the CA certificate.
     */
    public String ownedBy() {
        return ownedBy;
    }

    /**
     * <p>
     * The date the CA certificate was created.
     * </p>
     * 
     * @return The date the CA certificate was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and
     * "DISABLE"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoRegistrationStatusString}.
     * </p>
     * 
     * @return Whether the CA certificate configured for auto registration of device certificates. Valid values are
     *         "ENABLE" and "DISABLE"
     * @see AutoRegistrationStatus
     */
    public AutoRegistrationStatus autoRegistrationStatus() {
        return AutoRegistrationStatus.fromValue(autoRegistrationStatus);
    }

    /**
     * <p>
     * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE" and
     * "DISABLE"
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #autoRegistrationStatus} will return {@link AutoRegistrationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #autoRegistrationStatusString}.
     * </p>
     * 
     * @return Whether the CA certificate configured for auto registration of device certificates. Valid values are
     *         "ENABLE" and "DISABLE"
     * @see AutoRegistrationStatus
     */
    public String autoRegistrationStatusString() {
        return autoRegistrationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(statusString());
        hashCode = 31 * hashCode + Objects.hashCode(certificatePem());
        hashCode = 31 * hashCode + Objects.hashCode(ownedBy());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(autoRegistrationStatusString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CACertificateDescription)) {
            return false;
        }
        CACertificateDescription other = (CACertificateDescription) obj;
        return Objects.equals(certificateArn(), other.certificateArn()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(statusString(), other.statusString())
                && Objects.equals(certificatePem(), other.certificatePem()) && Objects.equals(ownedBy(), other.ownedBy())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(autoRegistrationStatusString(), other.autoRegistrationStatusString());
    }

    @Override
    public String toString() {
        return ToString.builder("CACertificateDescription").add("CertificateArn", certificateArn())
                .add("CertificateId", certificateId()).add("Status", statusString()).add("CertificatePem", certificatePem())
                .add("OwnedBy", ownedBy()).add("CreationDate", creationDate())
                .add("AutoRegistrationStatus", autoRegistrationStatusString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "certificateArn":
            return Optional.of(clazz.cast(certificateArn()));
        case "certificateId":
            return Optional.of(clazz.cast(certificateId()));
        case "status":
            return Optional.of(clazz.cast(statusString()));
        case "certificatePem":
            return Optional.of(clazz.cast(certificatePem()));
        case "ownedBy":
            return Optional.of(clazz.cast(ownedBy()));
        case "creationDate":
            return Optional.of(clazz.cast(creationDate()));
        case "autoRegistrationStatus":
            return Optional.of(clazz.cast(autoRegistrationStatusString()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CACertificateDescriptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CACertificateDescription> {
        /**
         * <p>
         * The CA certificate ARN.
         * </p>
         * 
         * @param certificateArn
         *        The CA certificate ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The CA certificate ID.
         * </p>
         * 
         * @param certificateId
         *        The CA certificate ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a CA certificate.
         * </p>
         * 
         * @param status
         *        The status of a CA certificate.
         * @see CACertificateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CACertificateStatus
         */
        Builder status(CACertificateStatus status);

        /**
         * <p>
         * The CA certificate data, in PEM format.
         * </p>
         * 
         * @param certificatePem
         *        The CA certificate data, in PEM format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificatePem(String certificatePem);

        /**
         * <p>
         * The owner of the CA certificate.
         * </p>
         * 
         * @param ownedBy
         *        The owner of the CA certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownedBy(String ownedBy);

        /**
         * <p>
         * The date the CA certificate was created.
         * </p>
         * 
         * @param creationDate
         *        The date the CA certificate was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(String autoRegistrationStatus);

        /**
         * <p>
         * Whether the CA certificate configured for auto registration of device certificates. Valid values are "ENABLE"
         * and "DISABLE"
         * </p>
         * 
         * @param autoRegistrationStatus
         *        Whether the CA certificate configured for auto registration of device certificates. Valid values are
         *        "ENABLE" and "DISABLE"
         * @see AutoRegistrationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoRegistrationStatus
         */
        Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String certificateArn;

        private String certificateId;

        private String status;

        private String certificatePem;

        private String ownedBy;

        private Instant creationDate;

        private String autoRegistrationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CACertificateDescription model) {
            certificateArn(model.certificateArn);
            certificateId(model.certificateId);
            status(model.status);
            certificatePem(model.certificatePem);
            ownedBy(model.ownedBy);
            creationDate(model.creationDate);
            autoRegistrationStatus(model.autoRegistrationStatus);
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CACertificateStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCertificatePem() {
            return certificatePem;
        }

        @Override
        public final Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            return this;
        }

        public final void setCertificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
        }

        public final String getOwnedBy() {
            return ownedBy;
        }

        @Override
        public final Builder ownedBy(String ownedBy) {
            this.ownedBy = ownedBy;
            return this;
        }

        public final void setOwnedBy(String ownedBy) {
            this.ownedBy = ownedBy;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getAutoRegistrationStatus() {
            return autoRegistrationStatus;
        }

        @Override
        public final Builder autoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
            return this;
        }

        @Override
        public final Builder autoRegistrationStatus(AutoRegistrationStatus autoRegistrationStatus) {
            this.autoRegistrationStatus(autoRegistrationStatus.toString());
            return this;
        }

        public final void setAutoRegistrationStatus(String autoRegistrationStatus) {
            this.autoRegistrationStatus = autoRegistrationStatus;
        }

        @Override
        public CACertificateDescription build() {
            return new CACertificateDescription(this);
        }
    }
}
