/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The output from the ListThingPrincipals operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListThingPrincipalsResponse extends IoTResponse implements
        ToCopyableBuilder<ListThingPrincipalsResponse.Builder, ListThingPrincipalsResponse> {
    private final List<String> principals;

    private ListThingPrincipalsResponse(BuilderImpl builder) {
        super(builder);
        this.principals = builder.principals;
    }

    /**
     * <p>
     * The principals associated with the thing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The principals associated with the thing.
     */
    public List<String> principals() {
        return principals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListThingPrincipalsResponse)) {
            return false;
        }
        ListThingPrincipalsResponse other = (ListThingPrincipalsResponse) obj;
        return Objects.equals(principals(), other.principals());
    }

    @Override
    public String toString() {
        return ToString.builder("ListThingPrincipalsResponse").add("Principals", principals()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "principals":
            return Optional.of(clazz.cast(principals()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends IoTResponse.Builder, CopyableBuilder<Builder, ListThingPrincipalsResponse> {
        /**
         * <p>
         * The principals associated with the thing.
         * </p>
         * 
         * @param principals
         *        The principals associated with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * The principals associated with the thing.
         * </p>
         * 
         * @param principals
         *        The principals associated with the thing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);
    }

    static final class BuilderImpl extends IoTResponse.BuilderImpl implements Builder {
        private List<String> principals;

        private BuilderImpl() {
        }

        private BuilderImpl(ListThingPrincipalsResponse model) {
            principals(model.principals);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = PrincipalsCopier.copy(principals);
        }

        @Override
        public ListThingPrincipalsResponse build() {
            return new ListThingPrincipalsResponse(this);
        }
    }
}
