/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, ListCertificatesRequest> {
    private final Integer pageSize;
    private final String marker;
    private final Boolean ascendingOrder;

    private ListCertificatesRequest(BuilderImpl builder) {
        super(builder);
        this.pageSize = builder.pageSize;
        this.marker = builder.marker;
        this.ascendingOrder = builder.ascendingOrder;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public String marker() {
        return this.marker;
    }

    public Boolean ascendingOrder() {
        return this.ascendingOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.ascendingOrder());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)((Object)obj);
        return Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.ascendingOrder(), other.ascendingOrder());
    }

    public String toString() {
        return ToString.builder((String)"ListCertificatesRequest").add("PageSize", (Object)this.pageSize()).add("Marker", (Object)this.marker()).add("AscendingOrder", (Object)this.ascendingOrder()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pageSize": {
                return Optional.of(clazz.cast(this.pageSize()));
            }
            case "marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ascendingOrder": {
                return Optional.of(clazz.cast(this.ascendingOrder()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private Integer pageSize;
        private String marker;
        private Boolean ascendingOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesRequest model) {
            this.pageSize(model.pageSize);
            this.marker(model.marker);
            this.ascendingOrder(model.ascendingOrder);
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Boolean getAscendingOrder() {
            return this.ascendingOrder;
        }

        @Override
        public final Builder ascendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
            return this;
        }

        public final void setAscendingOrder(Boolean ascendingOrder) {
            this.ascendingOrder = ascendingOrder;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ListCertificatesRequest build() {
            return new ListCertificatesRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, ListCertificatesRequest> {
        public Builder pageSize(Integer var1);

        public Builder marker(String var1);

        public Builder ascendingOrder(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

