/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.iot.model.IoTResponse;
import software.amazon.awssdk.services.iot.model.PolicyVersion;
import software.amazon.awssdk.services.iot.model.PolicyVersionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListPolicyVersionsResponse
extends IoTResponse
implements ToCopyableBuilder<Builder, ListPolicyVersionsResponse> {
    private final List<PolicyVersion> policyVersions;

    private ListPolicyVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersions = builder.policyVersions;
    }

    public List<PolicyVersion> policyVersions() {
        return this.policyVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPolicyVersionsResponse)) {
            return false;
        }
        ListPolicyVersionsResponse other = (ListPolicyVersionsResponse)((Object)obj);
        return Objects.equals(this.policyVersions(), other.policyVersions());
    }

    public String toString() {
        return ToString.builder((String)"ListPolicyVersionsResponse").add("PolicyVersions", this.policyVersions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "policyVersions": {
                return Optional.of(clazz.cast(this.policyVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTResponse.BuilderImpl
    implements Builder {
        private List<PolicyVersion> policyVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPolicyVersionsResponse model) {
            this.policyVersions(model.policyVersions);
        }

        public final Collection<PolicyVersion.Builder> getPolicyVersions() {
            return this.policyVersions != null ? (Collection)this.policyVersions.stream().map(PolicyVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder policyVersions(Collection<PolicyVersion> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copy(policyVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyVersions(PolicyVersion ... policyVersions) {
            this.policyVersions(Arrays.asList(policyVersions));
            return this;
        }

        public final void setPolicyVersions(Collection<PolicyVersion.BuilderImpl> policyVersions) {
            this.policyVersions = PolicyVersionsCopier.copyFromBuilder(policyVersions);
        }

        @Override
        public ListPolicyVersionsResponse build() {
            return new ListPolicyVersionsResponse(this);
        }
    }

    public static interface Builder
    extends IoTResponse.Builder,
    CopyableBuilder<Builder, ListPolicyVersionsResponse> {
        public Builder policyVersions(Collection<PolicyVersion> var1);

        public Builder policyVersions(PolicyVersion ... var1);
    }
}

