/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class RejectCertificateTransferRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, RejectCertificateTransferRequest> {
    private final String certificateId;
    private final String rejectReason;

    private RejectCertificateTransferRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.rejectReason = builder.rejectReason;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String rejectReason() {
        return this.rejectReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rejectReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RejectCertificateTransferRequest)) {
            return false;
        }
        RejectCertificateTransferRequest other = (RejectCertificateTransferRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.rejectReason(), other.rejectReason());
    }

    public String toString() {
        return ToString.builder((String)"RejectCertificateTransferRequest").add("CertificateId", (Object)this.certificateId()).add("RejectReason", (Object)this.rejectReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "rejectReason": {
                return Optional.of(clazz.cast(this.rejectReason()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String rejectReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RejectCertificateTransferRequest model) {
            this.certificateId(model.certificateId);
            this.rejectReason(model.rejectReason);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getRejectReason() {
            return this.rejectReason;
        }

        @Override
        public final Builder rejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
            return this;
        }

        public final void setRejectReason(String rejectReason) {
            this.rejectReason = rejectReason;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public RejectCertificateTransferRequest build() {
            return new RejectCertificateTransferRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, RejectCertificateTransferRequest> {
        public Builder certificateId(String var1);

        public Builder rejectReason(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

