/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TransferCertificateRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, TransferCertificateRequest> {
    private final String certificateId;
    private final String targetAwsAccount;
    private final String transferMessage;

    private TransferCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateId = builder.certificateId;
        this.targetAwsAccount = builder.targetAwsAccount;
        this.transferMessage = builder.transferMessage;
    }

    public String certificateId() {
        return this.certificateId;
    }

    public String targetAwsAccount() {
        return this.targetAwsAccount;
    }

    public String transferMessage() {
        return this.transferMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAwsAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.transferMessage());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransferCertificateRequest)) {
            return false;
        }
        TransferCertificateRequest other = (TransferCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateId(), other.certificateId()) && Objects.equals(this.targetAwsAccount(), other.targetAwsAccount()) && Objects.equals(this.transferMessage(), other.transferMessage());
    }

    public String toString() {
        return ToString.builder((String)"TransferCertificateRequest").add("CertificateId", (Object)this.certificateId()).add("TargetAwsAccount", (Object)this.targetAwsAccount()).add("TransferMessage", (Object)this.transferMessage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "certificateId": {
                return Optional.of(clazz.cast(this.certificateId()));
            }
            case "targetAwsAccount": {
                return Optional.of(clazz.cast(this.targetAwsAccount()));
            }
            case "transferMessage": {
                return Optional.of(clazz.cast(this.transferMessage()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String certificateId;
        private String targetAwsAccount;
        private String transferMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(TransferCertificateRequest model) {
            this.certificateId(model.certificateId);
            this.targetAwsAccount(model.targetAwsAccount);
            this.transferMessage(model.transferMessage);
        }

        public final String getCertificateId() {
            return this.certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getTargetAwsAccount() {
            return this.targetAwsAccount;
        }

        @Override
        public final Builder targetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
            return this;
        }

        public final void setTargetAwsAccount(String targetAwsAccount) {
            this.targetAwsAccount = targetAwsAccount;
        }

        public final String getTransferMessage() {
            return this.transferMessage;
        }

        @Override
        public final Builder transferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
            return this;
        }

        public final void setTransferMessage(String transferMessage) {
            this.transferMessage = transferMessage;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TransferCertificateRequest build() {
            return new TransferCertificateRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, TransferCertificateRequest> {
        public Builder certificateId(String var1);

        public Builder targetAwsAccount(String var1);

        public Builder transferMessage(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

