/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.iot.model.AttributePayload;
import software.amazon.awssdk.services.iot.model.IoTRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateThingRequest
extends IoTRequest
implements ToCopyableBuilder<Builder, UpdateThingRequest> {
    private final String thingName;
    private final String thingTypeName;
    private final AttributePayload attributePayload;
    private final Long expectedVersion;
    private final Boolean removeThingType;

    private UpdateThingRequest(BuilderImpl builder) {
        super(builder);
        this.thingName = builder.thingName;
        this.thingTypeName = builder.thingTypeName;
        this.attributePayload = builder.attributePayload;
        this.expectedVersion = builder.expectedVersion;
        this.removeThingType = builder.removeThingType;
    }

    public String thingName() {
        return this.thingName;
    }

    public String thingTypeName() {
        return this.thingTypeName;
    }

    public AttributePayload attributePayload() {
        return this.attributePayload;
    }

    public Long expectedVersion() {
        return this.expectedVersion;
    }

    public Boolean removeThingType() {
        return this.removeThingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.thingName());
        hashCode = 31 * hashCode + Objects.hashCode(this.thingTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributePayload());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.removeThingType());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThingRequest)) {
            return false;
        }
        UpdateThingRequest other = (UpdateThingRequest)((Object)obj);
        return Objects.equals(this.thingName(), other.thingName()) && Objects.equals(this.thingTypeName(), other.thingTypeName()) && Objects.equals(this.attributePayload(), other.attributePayload()) && Objects.equals(this.expectedVersion(), other.expectedVersion()) && Objects.equals(this.removeThingType(), other.removeThingType());
    }

    public String toString() {
        return ToString.builder((String)"UpdateThingRequest").add("ThingName", (Object)this.thingName()).add("ThingTypeName", (Object)this.thingTypeName()).add("AttributePayload", (Object)this.attributePayload()).add("ExpectedVersion", (Object)this.expectedVersion()).add("RemoveThingType", (Object)this.removeThingType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "thingName": {
                return Optional.of(clazz.cast(this.thingName()));
            }
            case "thingTypeName": {
                return Optional.of(clazz.cast(this.thingTypeName()));
            }
            case "attributePayload": {
                return Optional.of(clazz.cast(this.attributePayload()));
            }
            case "expectedVersion": {
                return Optional.of(clazz.cast(this.expectedVersion()));
            }
            case "removeThingType": {
                return Optional.of(clazz.cast(this.removeThingType()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends IoTRequest.BuilderImpl
    implements Builder {
        private String thingName;
        private String thingTypeName;
        private AttributePayload attributePayload;
        private Long expectedVersion;
        private Boolean removeThingType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThingRequest model) {
            this.thingName(model.thingName);
            this.thingTypeName(model.thingTypeName);
            this.attributePayload(model.attributePayload);
            this.expectedVersion(model.expectedVersion);
            this.removeThingType(model.removeThingType);
        }

        public final String getThingName() {
            return this.thingName;
        }

        @Override
        public final Builder thingName(String thingName) {
            this.thingName = thingName;
            return this;
        }

        public final void setThingName(String thingName) {
            this.thingName = thingName;
        }

        public final String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final Builder thingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        public final void setThingTypeName(String thingTypeName) {
            this.thingTypeName = thingTypeName;
        }

        public final AttributePayload.Builder getAttributePayload() {
            return this.attributePayload != null ? this.attributePayload.toBuilder() : null;
        }

        @Override
        public final Builder attributePayload(AttributePayload attributePayload) {
            this.attributePayload = attributePayload;
            return this;
        }

        public final void setAttributePayload(AttributePayload.BuilderImpl attributePayload) {
            this.attributePayload = attributePayload != null ? attributePayload.build() : null;
        }

        public final Long getExpectedVersion() {
            return this.expectedVersion;
        }

        @Override
        public final Builder expectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
            return this;
        }

        public final void setExpectedVersion(Long expectedVersion) {
            this.expectedVersion = expectedVersion;
        }

        public final Boolean getRemoveThingType() {
            return this.removeThingType;
        }

        @Override
        public final Builder removeThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
            return this;
        }

        public final void setRemoveThingType(Boolean removeThingType) {
            this.removeThingType = removeThingType;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateThingRequest build() {
            return new UpdateThingRequest(this);
        }
    }

    public static interface Builder
    extends IoTRequest.Builder,
    CopyableBuilder<Builder, UpdateThingRequest> {
        public Builder thingName(String var1);

        public Builder thingTypeName(String var1);

        public Builder attributePayload(AttributePayload var1);

        default public Builder attributePayload(Consumer<AttributePayload.Builder> attributePayload) {
            return this.attributePayload((AttributePayload)((AttributePayload.Builder)AttributePayload.builder().apply(attributePayload)).build());
        }

        public Builder expectedVersion(Long var1);

        public Builder removeThingType(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

