/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.iot.model.CertificateDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CertificateDescriptionMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").isBinary(false).build();
    private static final MarshallingInfo<String> CACERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("caCertificateId").isBinary(false).build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEPEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificatePem").isBinary(false).build();
    private static final MarshallingInfo<String> OWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ownedBy").isBinary(false).build();
    private static final MarshallingInfo<String> PREVIOUSOWNEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("previousOwnedBy").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final MarshallingInfo<Instant> LASTMODIFIEDDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("lastModifiedDate").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> TRANSFERDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferData").isBinary(false).build();
    private static final CertificateDescriptionMarshaller INSTANCE = new CertificateDescriptionMarshaller();

    private CertificateDescriptionMarshaller() {
    }

    public static CertificateDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CertificateDescription certificateDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)certificateDescription, (String)"certificateDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)certificateDescription.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.caCertificateId(), CACERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.statusString(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.certificatePem(), CERTIFICATEPEM_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.ownedBy(), OWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.previousOwnedBy(), PREVIOUSOWNEDBY_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.creationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.lastModifiedDate(), LASTMODIFIEDDATE_BINDING);
            protocolMarshaller.marshall((Object)certificateDescription.transferData(), TRANSFERDATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

