/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.LoggingOptionsPayload;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LoggingOptionsPayloadMarshaller {
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> LOGLEVEL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("logLevel").isBinary(false).build();
    private static final LoggingOptionsPayloadMarshaller INSTANCE = new LoggingOptionsPayloadMarshaller();

    private LoggingOptionsPayloadMarshaller() {
    }

    public static LoggingOptionsPayloadMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LoggingOptionsPayload loggingOptionsPayload, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)loggingOptionsPayload, (String)"loggingOptionsPayload");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)loggingOptionsPayload.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)loggingOptionsPayload.logLevelString(), LOGLEVEL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

