/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.OutgoingCertificate;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OutgoingCertificateMarshaller {
    private static final MarshallingInfo<String> CERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateArn").isBinary(false).build();
    private static final MarshallingInfo<String> CERTIFICATEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("certificateId").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSFERREDTO_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferredTo").isBinary(false).build();
    private static final MarshallingInfo<Instant> TRANSFERDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferDate").isBinary(false).build();
    private static final MarshallingInfo<String> TRANSFERMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("transferMessage").isBinary(false).build();
    private static final MarshallingInfo<Instant> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("creationDate").isBinary(false).build();
    private static final OutgoingCertificateMarshaller INSTANCE = new OutgoingCertificateMarshaller();

    private OutgoingCertificateMarshaller() {
    }

    public static OutgoingCertificateMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(OutgoingCertificate outgoingCertificate, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)outgoingCertificate, (String)"outgoingCertificate");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)outgoingCertificate.certificateArn(), CERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)outgoingCertificate.certificateId(), CERTIFICATEID_BINDING);
            protocolMarshaller.marshall((Object)outgoingCertificate.transferredTo(), TRANSFERREDTO_BINDING);
            protocolMarshaller.marshall((Object)outgoingCertificate.transferDate(), TRANSFERDATE_BINDING);
            protocolMarshaller.marshall((Object)outgoingCertificate.transferMessage(), TRANSFERMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)outgoingCertificate.creationDate(), CREATIONDATE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

