/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.iot.model.SnsAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class SnsActionMarshaller {
    private static final MarshallingInfo<String> TARGETARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("targetArn").isBinary(false).build();
    private static final MarshallingInfo<String> ROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleArn").isBinary(false).build();
    private static final MarshallingInfo<String> MESSAGEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("messageFormat").isBinary(false).build();
    private static final SnsActionMarshaller INSTANCE = new SnsActionMarshaller();

    private SnsActionMarshaller() {
    }

    public static SnsActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SnsAction snsAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)snsAction, (String)"snsAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)snsAction.targetArn(), TARGETARN_BINDING);
            protocolMarshaller.marshall((Object)snsAction.roleArn(), ROLEARN_BINDING);
            protocolMarshaller.marshall((Object)snsAction.messageFormatString(), MESSAGEFORMAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

