/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AuthorizerStatus;
import software.amazon.awssdk.services.iot.model.PublicKeyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizerDescription
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizerDescription> {
    private static final SdkField<String> AUTHORIZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerName)).setter(AuthorizerDescription.setter(Builder::authorizerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerName").build()}).build();
    private static final SdkField<String> AUTHORIZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerArn)).setter(AuthorizerDescription.setter(Builder::authorizerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerArn").build()}).build();
    private static final SdkField<String> AUTHORIZER_FUNCTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizerDescription.getter(AuthorizerDescription::authorizerFunctionArn)).setter(AuthorizerDescription.setter(Builder::authorizerFunctionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerFunctionArn").build()}).build();
    private static final SdkField<String> TOKEN_KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizerDescription.getter(AuthorizerDescription::tokenKeyName)).setter(AuthorizerDescription.setter(Builder::tokenKeyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenKeyName").build()}).build();
    private static final SdkField<Map<String, String>> TOKEN_SIGNING_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(AuthorizerDescription.getter(AuthorizerDescription::tokenSigningPublicKeys)).setter(AuthorizerDescription.setter(Builder::tokenSigningPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenSigningPublicKeys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AuthorizerDescription.getter(AuthorizerDescription::statusAsString)).setter(AuthorizerDescription.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AuthorizerDescription.getter(AuthorizerDescription::creationDate)).setter(AuthorizerDescription.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(AuthorizerDescription.getter(AuthorizerDescription::lastModifiedDate)).setter(AuthorizerDescription.setter(Builder::lastModifiedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZER_NAME_FIELD, AUTHORIZER_ARN_FIELD, AUTHORIZER_FUNCTION_ARN_FIELD, TOKEN_KEY_NAME_FIELD, TOKEN_SIGNING_PUBLIC_KEYS_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizerName;
    private final String authorizerArn;
    private final String authorizerFunctionArn;
    private final String tokenKeyName;
    private final Map<String, String> tokenSigningPublicKeys;
    private final String status;
    private final Instant creationDate;
    private final Instant lastModifiedDate;

    private AuthorizerDescription(BuilderImpl builder) {
        this.authorizerName = builder.authorizerName;
        this.authorizerArn = builder.authorizerArn;
        this.authorizerFunctionArn = builder.authorizerFunctionArn;
        this.tokenKeyName = builder.tokenKeyName;
        this.tokenSigningPublicKeys = builder.tokenSigningPublicKeys;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public String authorizerName() {
        return this.authorizerName;
    }

    public String authorizerArn() {
        return this.authorizerArn;
    }

    public String authorizerFunctionArn() {
        return this.authorizerFunctionArn;
    }

    public String tokenKeyName() {
        return this.tokenKeyName;
    }

    public Map<String, String> tokenSigningPublicKeys() {
        return this.tokenSigningPublicKeys;
    }

    public AuthorizerStatus status() {
        return AuthorizerStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerFunctionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenSigningPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizerDescription)) {
            return false;
        }
        AuthorizerDescription other = (AuthorizerDescription)obj;
        return Objects.equals(this.authorizerName(), other.authorizerName()) && Objects.equals(this.authorizerArn(), other.authorizerArn()) && Objects.equals(this.authorizerFunctionArn(), other.authorizerFunctionArn()) && Objects.equals(this.tokenKeyName(), other.tokenKeyName()) && Objects.equals(this.tokenSigningPublicKeys(), other.tokenSigningPublicKeys()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate());
    }

    public String toString() {
        return ToString.builder((String)"AuthorizerDescription").add("AuthorizerName", (Object)this.authorizerName()).add("AuthorizerArn", (Object)this.authorizerArn()).add("AuthorizerFunctionArn", (Object)this.authorizerFunctionArn()).add("TokenKeyName", (Object)this.tokenKeyName()).add("TokenSigningPublicKeys", this.tokenSigningPublicKeys()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).add("LastModifiedDate", (Object)this.lastModifiedDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizerName": {
                return Optional.ofNullable(clazz.cast(this.authorizerName()));
            }
            case "authorizerArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerArn()));
            }
            case "authorizerFunctionArn": {
                return Optional.ofNullable(clazz.cast(this.authorizerFunctionArn()));
            }
            case "tokenKeyName": {
                return Optional.ofNullable(clazz.cast(this.tokenKeyName()));
            }
            case "tokenSigningPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.tokenSigningPublicKeys()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "creationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "lastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizerDescription, T> g) {
        return obj -> g.apply((AuthorizerDescription)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizerName;
        private String authorizerArn;
        private String authorizerFunctionArn;
        private String tokenKeyName;
        private Map<String, String> tokenSigningPublicKeys = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private Instant creationDate;
        private Instant lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizerDescription model) {
            this.authorizerName(model.authorizerName);
            this.authorizerArn(model.authorizerArn);
            this.authorizerFunctionArn(model.authorizerFunctionArn);
            this.tokenKeyName(model.tokenKeyName);
            this.tokenSigningPublicKeys(model.tokenSigningPublicKeys);
            this.status(model.status);
            this.creationDate(model.creationDate);
            this.lastModifiedDate(model.lastModifiedDate);
        }

        public final String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final Builder authorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        public final void setAuthorizerName(String authorizerName) {
            this.authorizerName = authorizerName;
        }

        public final String getAuthorizerArn() {
            return this.authorizerArn;
        }

        @Override
        public final Builder authorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
            return this;
        }

        public final void setAuthorizerArn(String authorizerArn) {
            this.authorizerArn = authorizerArn;
        }

        public final String getAuthorizerFunctionArn() {
            return this.authorizerFunctionArn;
        }

        @Override
        public final Builder authorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
            return this;
        }

        public final void setAuthorizerFunctionArn(String authorizerFunctionArn) {
            this.authorizerFunctionArn = authorizerFunctionArn;
        }

        public final String getTokenKeyName() {
            return this.tokenKeyName;
        }

        @Override
        public final Builder tokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
            return this;
        }

        public final void setTokenKeyName(String tokenKeyName) {
            this.tokenKeyName = tokenKeyName;
        }

        public final Map<String, String> getTokenSigningPublicKeys() {
            return this.tokenSigningPublicKeys;
        }

        @Override
        public final Builder tokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
            return this;
        }

        public final void setTokenSigningPublicKeys(Map<String, String> tokenSigningPublicKeys) {
            this.tokenSigningPublicKeys = PublicKeyMapCopier.copy(tokenSigningPublicKeys);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AuthorizerStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getLastModifiedDate() {
            return this.lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        public AuthorizerDescription build() {
            return new AuthorizerDescription(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizerDescription> {
        public Builder authorizerName(String var1);

        public Builder authorizerArn(String var1);

        public Builder authorizerFunctionArn(String var1);

        public Builder tokenKeyName(String var1);

        public Builder tokenSigningPublicKeys(Map<String, String> var1);

        public Builder status(String var1);

        public Builder status(AuthorizerStatus var1);

        public Builder creationDate(Instant var1);

        public Builder lastModifiedDate(Instant var1);
    }
}

