/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iot.model.AlertTarget;
import software.amazon.awssdk.services.iot.model.AlertTargetType;
import software.amazon.awssdk.services.iot.model.AlertTargetsCopier;
import software.amazon.awssdk.services.iot.model.Behavior;
import software.amazon.awssdk.services.iot.model.BehaviorsCopier;
import software.amazon.awssdk.services.iot.model.IotRequest;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSecurityProfileRequest
extends IotRequest
implements ToCopyableBuilder<Builder, CreateSecurityProfileRequest> {
    private static final SdkField<String> SECURITY_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::securityProfileName)).setter(CreateSecurityProfileRequest.setter(Builder::securityProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("securityProfileName").build()}).build();
    private static final SdkField<String> SECURITY_PROFILE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::securityProfileDescription)).setter(CreateSecurityProfileRequest.setter(Builder::securityProfileDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityProfileDescription").build()}).build();
    private static final SdkField<List<Behavior>> BEHAVIORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::behaviors)).setter(CreateSecurityProfileRequest.setter(Builder::behaviors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("behaviors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Behavior::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, AlertTarget>> ALERT_TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateSecurityProfileRequest.getter(CreateSecurityProfileRequest::alertTargetsAsStrings)).setter(CreateSecurityProfileRequest.setter(Builder::alertTargetsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alertTargets").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlertTarget::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_PROFILE_NAME_FIELD, SECURITY_PROFILE_DESCRIPTION_FIELD, BEHAVIORS_FIELD, ALERT_TARGETS_FIELD));
    private final String securityProfileName;
    private final String securityProfileDescription;
    private final List<Behavior> behaviors;
    private final Map<String, AlertTarget> alertTargets;

    private CreateSecurityProfileRequest(BuilderImpl builder) {
        super(builder);
        this.securityProfileName = builder.securityProfileName;
        this.securityProfileDescription = builder.securityProfileDescription;
        this.behaviors = builder.behaviors;
        this.alertTargets = builder.alertTargets;
    }

    public String securityProfileName() {
        return this.securityProfileName;
    }

    public String securityProfileDescription() {
        return this.securityProfileDescription;
    }

    public List<Behavior> behaviors() {
        return this.behaviors;
    }

    public Map<AlertTargetType, AlertTarget> alertTargets() {
        return TypeConverter.convert(this.alertTargets, AlertTargetType::fromValue, Function.identity(), (k, v) -> !Objects.equals(k, (Object)AlertTargetType.UNKNOWN_TO_SDK_VERSION));
    }

    public Map<String, AlertTarget> alertTargetsAsStrings() {
        return this.alertTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityProfileDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviors());
        hashCode = 31 * hashCode + Objects.hashCode(this.alertTargetsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityProfileRequest)) {
            return false;
        }
        CreateSecurityProfileRequest other = (CreateSecurityProfileRequest)((Object)obj);
        return Objects.equals(this.securityProfileName(), other.securityProfileName()) && Objects.equals(this.securityProfileDescription(), other.securityProfileDescription()) && Objects.equals(this.behaviors(), other.behaviors()) && Objects.equals(this.alertTargetsAsStrings(), other.alertTargetsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"CreateSecurityProfileRequest").add("SecurityProfileName", (Object)this.securityProfileName()).add("SecurityProfileDescription", (Object)this.securityProfileDescription()).add("Behaviors", this.behaviors()).add("AlertTargets", this.alertTargetsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "securityProfileName": {
                return Optional.ofNullable(clazz.cast(this.securityProfileName()));
            }
            case "securityProfileDescription": {
                return Optional.ofNullable(clazz.cast(this.securityProfileDescription()));
            }
            case "behaviors": {
                return Optional.ofNullable(clazz.cast(this.behaviors()));
            }
            case "alertTargets": {
                return Optional.ofNullable(clazz.cast(this.alertTargetsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityProfileRequest, T> g) {
        return obj -> g.apply((CreateSecurityProfileRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IotRequest.BuilderImpl
    implements Builder {
        private String securityProfileName;
        private String securityProfileDescription;
        private List<Behavior> behaviors = DefaultSdkAutoConstructList.getInstance();
        private Map<String, AlertTarget> alertTargets = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityProfileRequest model) {
            super(model);
            this.securityProfileName(model.securityProfileName);
            this.securityProfileDescription(model.securityProfileDescription);
            this.behaviors(model.behaviors);
            this.alertTargetsWithStrings(model.alertTargets);
        }

        public final String getSecurityProfileName() {
            return this.securityProfileName;
        }

        @Override
        public final Builder securityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
            return this;
        }

        public final void setSecurityProfileName(String securityProfileName) {
            this.securityProfileName = securityProfileName;
        }

        public final String getSecurityProfileDescription() {
            return this.securityProfileDescription;
        }

        @Override
        public final Builder securityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
            return this;
        }

        public final void setSecurityProfileDescription(String securityProfileDescription) {
            this.securityProfileDescription = securityProfileDescription;
        }

        public final Collection<Behavior.Builder> getBehaviors() {
            return this.behaviors != null ? (Collection)this.behaviors.stream().map(Behavior::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder behaviors(Collection<Behavior> behaviors) {
            this.behaviors = BehaviorsCopier.copy(behaviors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Behavior ... behaviors) {
            this.behaviors(Arrays.asList(behaviors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder behaviors(Consumer<Behavior.Builder> ... behaviors) {
            this.behaviors(Stream.of(behaviors).map(c -> (Behavior)((Behavior.Builder)Behavior.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBehaviors(Collection<Behavior.BuilderImpl> behaviors) {
            this.behaviors = BehaviorsCopier.copyFromBuilder(behaviors);
        }

        public final Map<String, AlertTarget.Builder> getAlertTargets() {
            return this.alertTargets != null ? CollectionUtils.mapValues(this.alertTargets, AlertTarget::toBuilder) : null;
        }

        @Override
        public final Builder alertTargetsWithStrings(Map<String, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copy(alertTargets);
            return this;
        }

        @Override
        public final Builder alertTargets(Map<AlertTargetType, AlertTarget> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyEnumToString(alertTargets);
            return this;
        }

        public final void setAlertTargets(Map<String, AlertTarget.BuilderImpl> alertTargets) {
            this.alertTargets = AlertTargetsCopier.copyFromBuilder(alertTargets);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityProfileRequest build() {
            return new CreateSecurityProfileRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IotRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSecurityProfileRequest> {
        public Builder securityProfileName(String var1);

        public Builder securityProfileDescription(String var1);

        public Builder behaviors(Collection<Behavior> var1);

        public Builder behaviors(Behavior ... var1);

        public Builder behaviors(Consumer<Behavior.Builder> ... var1);

        public Builder alertTargetsWithStrings(Map<String, AlertTarget> var1);

        public Builder alertTargets(Map<AlertTargetType, AlertTarget> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

