/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name and ARN of a group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupNameAndArn implements SdkPojo, Serializable, ToCopyableBuilder<GroupNameAndArn.Builder, GroupNameAndArn> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupNameAndArn::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupName").build()).build();

    private static final SdkField<String> GROUP_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupNameAndArn::groupArn)).setter(setter(Builder::groupArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            GROUP_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String groupName;

    private final String groupArn;

    private GroupNameAndArn(BuilderImpl builder) {
        this.groupName = builder.groupName;
        this.groupArn = builder.groupArn;
    }

    /**
     * <p>
     * The group name.
     * </p>
     * 
     * @return The group name.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The group ARN.
     * </p>
     * 
     * @return The group ARN.
     */
    public String groupArn() {
        return groupArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(groupArn());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupNameAndArn)) {
            return false;
        }
        GroupNameAndArn other = (GroupNameAndArn) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(groupArn(), other.groupArn());
    }

    @Override
    public String toString() {
        return ToString.builder("GroupNameAndArn").add("GroupName", groupName()).add("GroupArn", groupArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "groupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "groupArn":
            return Optional.ofNullable(clazz.cast(groupArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupNameAndArn, T> g) {
        return obj -> g.apply((GroupNameAndArn) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupNameAndArn> {
        /**
         * <p>
         * The group name.
         * </p>
         * 
         * @param groupName
         *        The group name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The group ARN.
         * </p>
         * 
         * @param groupArn
         *        The group ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupArn(String groupArn);
    }

    static final class BuilderImpl implements Builder {
        private String groupName;

        private String groupArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupNameAndArn model) {
            groupName(model.groupName);
            groupArn(model.groupArn);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getGroupArn() {
            return groupArn;
        }

        @Override
        public final Builder groupArn(String groupArn) {
            this.groupArn = groupArn;
            return this;
        }

        public final void setGroupArn(String groupArn) {
            this.groupArn = groupArn;
        }

        @Override
        public GroupNameAndArn build() {
            return new GroupNameAndArn(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
