/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoleAliasesResponse extends IotResponse implements
        ToCopyableBuilder<ListRoleAliasesResponse.Builder, ListRoleAliasesResponse> {
    private static final SdkField<List<String>> ROLE_ALIASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListRoleAliasesResponse::roleAliases))
            .setter(setter(Builder::roleAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleAliases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListRoleAliasesResponse::nextMarker)).setter(setter(Builder::nextMarker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextMarker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROLE_ALIASES_FIELD,
            NEXT_MARKER_FIELD));

    private final List<String> roleAliases;

    private final String nextMarker;

    private ListRoleAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.roleAliases = builder.roleAliases;
        this.nextMarker = builder.nextMarker;
    }

    /**
     * <p>
     * The role aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The role aliases.
     */
    public List<String> roleAliases() {
        return roleAliases;
    }

    /**
     * <p>
     * A marker used to get the next set of results.
     * </p>
     * 
     * @return A marker used to get the next set of results.
     */
    public String nextMarker() {
        return nextMarker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(roleAliases());
        hashCode = 31 * hashCode + Objects.hashCode(nextMarker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoleAliasesResponse)) {
            return false;
        }
        ListRoleAliasesResponse other = (ListRoleAliasesResponse) obj;
        return Objects.equals(roleAliases(), other.roleAliases()) && Objects.equals(nextMarker(), other.nextMarker());
    }

    @Override
    public String toString() {
        return ToString.builder("ListRoleAliasesResponse").add("RoleAliases", roleAliases()).add("NextMarker", nextMarker())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "roleAliases":
            return Optional.ofNullable(clazz.cast(roleAliases()));
        case "nextMarker":
            return Optional.ofNullable(clazz.cast(nextMarker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRoleAliasesResponse, T> g) {
        return obj -> g.apply((ListRoleAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IotResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListRoleAliasesResponse> {
        /**
         * <p>
         * The role aliases.
         * </p>
         * 
         * @param roleAliases
         *        The role aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliases(Collection<String> roleAliases);

        /**
         * <p>
         * The role aliases.
         * </p>
         * 
         * @param roleAliases
         *        The role aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleAliases(String... roleAliases);

        /**
         * <p>
         * A marker used to get the next set of results.
         * </p>
         * 
         * @param nextMarker
         *        A marker used to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextMarker(String nextMarker);
    }

    static final class BuilderImpl extends IotResponse.BuilderImpl implements Builder {
        private List<String> roleAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextMarker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoleAliasesResponse model) {
            super(model);
            roleAliases(model.roleAliases);
            nextMarker(model.nextMarker);
        }

        public final Collection<String> getRoleAliases() {
            return roleAliases;
        }

        @Override
        public final Builder roleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleAliases(String... roleAliases) {
            roleAliases(Arrays.asList(roleAliases));
            return this;
        }

        public final void setRoleAliases(Collection<String> roleAliases) {
            this.roleAliases = RoleAliasesCopier.copy(roleAliases);
        }

        public final String getNextMarker() {
            return nextMarker;
        }

        @Override
        public final Builder nextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
            return this;
        }

        public final void setNextMarker(String nextMarker) {
            this.nextMarker = nextMarker;
        }

        @Override
        public ListRoleAliasesResponse build() {
            return new ListRoleAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
