/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job
 * execution status is set to <code>IN_PROGRESS</code>. If the job execution status is not set to another terminal state
 * before the timer expires, it will be automatically set to <code>TIMED_OUT</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeoutConfig implements SdkPojo, Serializable, ToCopyableBuilder<TimeoutConfig.Builder, TimeoutConfig> {
    private static final SdkField<Long> IN_PROGRESS_TIMEOUT_IN_MINUTES_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(TimeoutConfig::inProgressTimeoutInMinutes))
            .setter(setter(Builder::inProgressTimeoutInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inProgressTimeoutInMinutes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(IN_PROGRESS_TIMEOUT_IN_MINUTES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long inProgressTimeoutInMinutes;

    private TimeoutConfig(BuilderImpl builder) {
        this.inProgressTimeoutInMinutes = builder.inProgressTimeoutInMinutes;
    }

    /**
     * <p>
     * Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout interval
     * can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be updated and will
     * apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS status for longer
     * than this interval, the job execution will fail and switch to the terminal <code>TIMED_OUT</code> status.
     * </p>
     * 
     * @return Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout
     *         interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be
     *         updated and will apply to all job executions for the job. Whenever a job execution remains in the
     *         IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the terminal
     *         <code>TIMED_OUT</code> status.
     */
    public Long inProgressTimeoutInMinutes() {
        return inProgressTimeoutInMinutes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inProgressTimeoutInMinutes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeoutConfig)) {
            return false;
        }
        TimeoutConfig other = (TimeoutConfig) obj;
        return Objects.equals(inProgressTimeoutInMinutes(), other.inProgressTimeoutInMinutes());
    }

    @Override
    public String toString() {
        return ToString.builder("TimeoutConfig").add("InProgressTimeoutInMinutes", inProgressTimeoutInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inProgressTimeoutInMinutes":
            return Optional.ofNullable(clazz.cast(inProgressTimeoutInMinutes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeoutConfig, T> g) {
        return obj -> g.apply((TimeoutConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeoutConfig> {
        /**
         * <p>
         * Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout
         * interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't be
         * updated and will apply to all job executions for the job. Whenever a job execution remains in the IN_PROGRESS
         * status for longer than this interval, the job execution will fail and switch to the terminal
         * <code>TIMED_OUT</code> status.
         * </p>
         * 
         * @param inProgressTimeoutInMinutes
         *        Specifies the amount of time, in minutes, this device has to finish execution of this job. The timeout
         *        interval can be anywhere between 1 minute and 7 days (1 to 10080 minutes). The in progress timer can't
         *        be updated and will apply to all job executions for the job. Whenever a job execution remains in the
         *        IN_PROGRESS status for longer than this interval, the job execution will fail and switch to the
         *        terminal <code>TIMED_OUT</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes);
    }

    static final class BuilderImpl implements Builder {
        private Long inProgressTimeoutInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeoutConfig model) {
            inProgressTimeoutInMinutes(model.inProgressTimeoutInMinutes);
        }

        public final Long getInProgressTimeoutInMinutes() {
            return inProgressTimeoutInMinutes;
        }

        @Override
        public final Builder inProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes) {
            this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
            return this;
        }

        public final void setInProgressTimeoutInMinutes(Long inProgressTimeoutInMinutes) {
            this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
        }

        @Override
        public TimeoutConfig build() {
            return new TimeoutConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
